/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class HarmonicSpectralSmoothness
extends FeatureExtractor {
    public HarmonicSpectralSmoothness() {
        String name = "Peak Based Spectral Smoothness";
        String description = "Peak Based Spectral Smoothness is calculated from partials, not frequency bins. It is implemented accortding to McAdams 99 " + System.getProperty("line.separator") + System.getProperty("line.separator") + "McAdams, S. 1999. ";
        this.definition = new FeatureDefinition(name, description, true, 1);
        this.dependencies = new String[]{"Peak Detection"};
        this.offsets = new int[1];
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) {
        double[] result = new double[1];
        double[] peak = other_feature_values[0];
        result[0] = 0.0;
        int i = 1;
        while (i < peak.length - 1) {
            result[0] = result[0] + Math.abs(20.0 * Math.log(peak[i]) - 20.0 * (Math.log(peak[i - 1]) + Math.log(peak[i]) + Math.log(peak[i + 1])) / 3.0);
            ++i;
        }
        return result;
    }

    @Override
    public Object clone() {
        return new HarmonicSpectralSmoothness();
    }
}

