/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class LPC
extends FeatureExtractor {
    double lambda = 0.0;
    int numDimensions = 10;

    public LPC() {
        String name = "LPC";
        String description = "Linear Prediction Coeffecients calculated using autocorrelation and Levinson-Durbin recursion.";
        String[] attributes = new String[]{"lambda for frequency warping", "number of coeffecients to calculate"};
        this.definition = new FeatureDefinition(name, description, true, 10, attributes);
        this.dependencies = null;
        this.offsets = null;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] R = new double[this.numDimensions + 1];
        double[] K = new double[this.numDimensions];
        double[] A = new double[this.numDimensions];
        double[] dl = new double[samples.length];
        double[] Rt = new double[samples.length];
        R[0] = 0.0;
        Rt[0] = 0.0;
        double r1 = 0.0;
        double r2 = 0.0;
        double r1t = 0.0;
        int k = 0;
        while (k < samples.length) {
            Rt[0] = Rt[0] + samples[k] * samples[k];
            dl[k] = r1 - this.lambda * (samples[k] - r2);
            r1 = samples[k];
            r2 = dl[k];
            ++k;
        }
        int i = 1;
        while (i < R.length) {
            Rt[i] = 0.0;
            r1 = 0.0;
            r2 = 0.0;
            int k2 = 0;
            while (k2 < samples.length) {
                int n = i;
                Rt[n] = Rt[n] + dl[k2] * samples[k2];
                r1t = dl[k2];
                dl[k2] = r1 - this.lambda * (r1t - r2);
                r1 = r1t;
                r2 = dl[k2];
                ++k2;
            }
            ++i;
        }
        i = 0;
        while (i < R.length) {
            R[i] = Rt[i];
            ++i;
        }
        double[] Am1 = new double[62];
        if (R[0] == 0.0) {
            int i2 = 1;
            while (i2 < this.numDimensions) {
                K[i2] = 0.0;
                A[i2] = 0.0;
                ++i2;
            }
        } else {
            int k3 = 0;
            while (k3 < this.numDimensions) {
                A[0] = 0.0;
                Am1[0] = 0.0;
                ++k3;
            }
            A[0] = 1.0;
            Am1[0] = 1.0;
            double km = 0.0;
            double Em1 = R[0];
            int m = 1;
            while (m < this.numDimensions) {
                double err = 0.0;
                k3 = 1;
                while (k3 <= m - 1) {
                    err += Am1[k3] * R[m - k3];
                    ++k3;
                }
                km = (R[m] - err) / Em1;
                K[m - 1] = -km;
                A[m] = km;
                k3 = 1;
                while (k3 <= m - 1) {
                    A[k3] = Am1[k3] - km * Am1[m - k3];
                    ++k3;
                }
                double Em = (1.0 - km * km) * Em1;
                int s = 0;
                while (s < this.numDimensions) {
                    Am1[s] = A[s];
                    ++s;
                }
                Em1 = Em;
                ++m;
            }
        }
        return K;
    }

    @Override
    public Object clone() {
        LPC ret = new LPC();
        ret.lambda = this.lambda;
        try {
            ret.setNumDimensions(this.numDimensions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ret.parent = this.parent;
        return ret;
    }

    @Override
    public String getElement(int index) throws Exception {
        switch (index) {
            case 0: {
                return Double.toString(this.lambda);
            }
            case 1: {
                return Integer.toString(this.numDimensions);
            }
        }
        throw new Exception("INTERNAL ERROR: invalid index " + index + " passed to LPC:getElement()");
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        switch (index) {
            case 0: {
                try {
                    this.setLambda(Double.parseDouble(value));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Lambda value must be a double");
                }
            }
            case 1: {
                try {
                    this.setNumDimensions(Integer.parseInt(value));
                    break;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Number of Dimensions must be an integer");
                }
            }
            default: {
                throw new Exception("INTERNAL ERROR: invalid index passed to LPC:setElement");
            }
        }
    }

    public void setNumDimensions(int n) throws Exception {
        if (n < 1) {
            throw new Exception("Must have at least 1 LPC coeffecient - " + n + " provided");
        }
        this.numDimensions = n;
        String name = this.definition.name;
        String description = this.definition.description;
        String[] attributes = this.definition.attributes;
        this.definition = new FeatureDefinition(name, description, true, this.numDimensions, attributes);
        if (this.parent != null) {
            this.parent.updateTable();
        }
    }

    public void setLambda(double l) throws Exception {
        if (Double.isNaN(l) || Double.isInfinite(l)) {
            throw new Exception("lambda must be a real number");
        }
        this.lambda = l;
    }
}

