/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import org.oc.ocvolume.dsp.featureExtraction;

public class MFCC
extends FeatureExtractor {
    featureExtraction fe;

    public MFCC() {
        String name = "MFCC";
        String description = "MFCC calculations based upon Orange Cow code";
        String[] attributes = new String[]{"Number of Coeffecients"};
        this.definition = new FeatureDefinition(name, description, true, 13, attributes);
        this.dependencies = new String[]{"Magnitude Spectrum"};
        this.offsets = new int[1];
        this.fe = new featureExtraction();
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        int[] cbin = this.fe.fftBinIndices(sampling_rate, other_feature_values[0].length);
        double[] fbank = this.fe.melFilter(other_feature_values[0], cbin);
        double[] f = this.fe.nonLinearTransformation(fbank);
        double[] cepc = this.fe.cepCoefficients(f);
        return cepc;
    }

    @Override
    public Object clone() {
        return new MFCC();
    }

    @Override
    public String getElement(int index) throws Exception {
        switch (index) {
            case 0: {
                return Integer.toString(this.fe.numCepstra);
            }
        }
        throw new Exception("INTERNAL ERROR: invalid index " + index + " passed to LPC:getElement()");
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        switch (index) {
            case 0: {
                try {
                    this.fe.numCepstra = Integer.parseInt(value);
                    String name = this.definition.name;
                    String description = this.definition.description;
                    String[] attributes = this.definition.attributes;
                    this.definition = new FeatureDefinition(name, description, true, this.fe.numCepstra, attributes);
                    if (this.parent == null) break;
                    this.parent.updateTable();
                    break;
                }
                catch (NumberFormatException e) {
                    throw new Exception("Lambda value must be a double");
                }
            }
            default: {
                throw new Exception("INTERNAL ERROR: invalid index passed to LPC:setElement");
            }
        }
    }
}

