/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import java.util.LinkedList;

public class PeakFinder
extends FeatureExtractor {
    int peakThreshold = 10;

    public PeakFinder() {
        String name = "Peak Detection";
        String description = "All peaks that are within an order of magnitude of the highest point";
        this.definition = new FeatureDefinition(name, description, true, 0, new String[]{"Threshold for peak detection"});
        this.dependencies = new String[]{"Magnitude Spectrum"};
        this.offsets = new int[1];
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        boolean count = false;
        double max = 0.0;
        double[] bins = other_feature_values[0];
        int i = 0;
        while (i < other_feature_values[0].length) {
            if (other_feature_values[0][i] > max) {
                max = other_feature_values[0][i];
            }
            ++i;
        }
        max /= (double)this.peakThreshold;
        LinkedList<Double> val = new LinkedList<Double>();
        int i2 = 1;
        while (i2 < bins.length - 1) {
            if (bins[i2 - 1] < bins[i2] && bins[i2 + 1] < bins[i2] && bins[i2] > max) {
                val.add(bins[i2]);
            }
            ++i2;
        }
        Double[] ret_tmp = val.toArray(new Double[0]);
        double[] ret = new double[ret_tmp.length];
        int i3 = 0;
        while (i3 < ret.length) {
            ret[i3] = ret_tmp[i3];
            ++i3;
        }
        return ret;
    }

    @Override
    public String getElement(int index) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: PeakFinder index != 0 (" + index + ")");
        }
        return Integer.toString(this.peakThreshold);
    }

    public void setPeakThreshold(int peak) throws Exception {
        if (peak <= 0) {
            throw new Exception("PeakFinder peakThreshold must be a positive value.");
        }
        this.peakThreshold = peak;
    }

    @Override
    public void setElement(int index, String value) throws Exception {
        if (index != 0) {
            throw new Exception("INTERNAL ERROR: PeakFinder index != 0 (" + index + ")");
        }
        try {
            this.setPeakThreshold(Integer.parseInt(value));
        }
        catch (NumberFormatException e) {
            throw new Exception("Peak Threshold Must be an integer");
        }
    }

    @Override
    public Object clone() {
        PeakFinder ret = new PeakFinder();
        try {
            ret.setPeakThreshold(this.peakThreshold);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }
}

