/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class RMS
extends FeatureExtractor {
    public RMS() {
        String name = "Root Mean Square";
        String description = "A measure of the power of a signal.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = null;
        this.offsets = null;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double sum = 0.0;
        int samp = 0;
        while (samp < samples.length) {
            sum += Math.pow(samples[samp], 2.0);
            ++samp;
        }
        double rms = Math.sqrt(sum / (double)samples.length);
        double[] result = new double[]{rms};
        return result;
    }

    @Override
    public Object clone() {
        return new RMS();
    }
}

