/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.Statistics;

public class StrengthOfStrongestBeat
extends FeatureExtractor {
    public StrengthOfStrongestBeat() {
        String name = "Strength Of Strongest Beat";
        String description = "How strong the strongest beat in the beat histogram is compared to other potential beats.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[2];
        this.dependencies[0] = "Beat Histogram";
        this.dependencies[1] = "Beat Sum";
        this.offsets = new int[2];
        this.offsets[0] = 0;
        this.offsets[1] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] beat_histogram = other_feature_values[0];
        if (beat_histogram != null) {
            double beat_sum = other_feature_values[1][0];
            int highest_bin = Statistics.getIndexOfLargest(beat_histogram);
            double highest_strength = beat_histogram[highest_bin];
            double normalized_strength = highest_strength / beat_sum;
            double[] result = new double[]{normalized_strength};
            return result;
        }
        return null;
    }

    @Override
    public Object clone() {
        return new StrengthOfStrongestBeat();
    }
}

