/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.GeneralTools.Statistics;

public class StrongestBeat
extends FeatureExtractor {
    public StrongestBeat() {
        String name = "Strongest Beat";
        String description = "The strongest beat in a signal, in beats per minute, found by finding the strongest bin in the beat histogram.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[2];
        this.dependencies[0] = "Beat Histogram";
        this.dependencies[1] = "Beat Histogram Bin Labels";
        this.offsets = new int[2];
        this.offsets[0] = 0;
        this.offsets[1] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double[] beat_histogram = other_feature_values[0];
        if (beat_histogram != null) {
            double[] labels = other_feature_values[1];
            int highest_bin = Statistics.getIndexOfLargest(beat_histogram);
            double[] result = new double[]{labels[highest_bin]};
            return result;
        }
        return null;
    }

    @Override
    public Object clone() {
        return new StrongestBeat();
    }
}

