/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.AudioFeatures;

import jAudioFeatureExtractor.ACE.DataTypes.FeatureDefinition;
import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;

public class StrongestFrequencyViaSpectralCentroid
extends FeatureExtractor {
    public StrongestFrequencyViaSpectralCentroid() {
        String name = "Strongest Frequency Via Spectral Centroid";
        String description = "The strongest frequency component of a signal, in Hz, found via the spectral centroid.";
        boolean is_sequential = true;
        int dimensions = 1;
        this.definition = new FeatureDefinition(name, description, is_sequential, dimensions);
        this.dependencies = new String[2];
        this.dependencies[0] = "Spectral Centroid";
        this.dependencies[1] = "Power Spectrum";
        this.offsets = new int[2];
        this.offsets[0] = 0;
        this.offsets[1] = 0;
    }

    @Override
    public double[] extractFeature(double[] samples, double sampling_rate, double[][] other_feature_values) throws Exception {
        double spectral_centroid = other_feature_values[0][0];
        double[] pow_spectrum = other_feature_values[1];
        double[] result = new double[]{spectral_centroid / (double)pow_spectrum.length * (sampling_rate / 2.0)};
        return result;
    }

    @Override
    public Object clone() {
        return new StrongestFrequencyViaSpectralCentroid();
    }
}

