/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.AudioFeatures.FeatureExtractor;
import jAudioFeatureExtractor.FeatureSelectorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class EditFeatures
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private FeatureSelectorPanel parent_;
    private JTextArea[] inputBoxes;
    private JLabel[] inputBoxLabels;
    private JLabel descriptionTitle;
    private JTextArea infoLabel;
    private JButton save;
    private JButton cancel;
    private int row;
    private FeatureExtractor fe_;

    EditFeatures(FeatureSelectorPanel parent, FeatureExtractor fe) {
        this.setTitle("Edit " + fe.getFeatureDefinition().name);
        Color blue = new Color(0.75f, 0.85f, 1.0f);
        this.getContentPane().setBackground(blue);
        this.setAlwaysOnTop(true);
        String[] attributes = fe.getFeatureDefinition().attributes;
        this.fe_ = fe;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditFeatures.this.cancel();
            }
        });
        this.inputBoxes = new JTextArea[attributes.length];
        this.inputBoxLabels = new JLabel[attributes.length];
        int i = 0;
        while (i < this.inputBoxes.length) {
            this.inputBoxes[i] = new JTextArea();
            try {
                this.inputBoxes[i].setText(this.fe_.getElement(i));
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
            }
            this.inputBoxLabels[i] = new JLabel(attributes[i]);
            ++i;
        }
        this.descriptionTitle = new JLabel("Description");
        this.infoLabel = new JTextArea(fe.getFeatureDefinition().description);
        this.infoLabel.setWrapStyleWord(true);
        this.infoLabel.setLineWrap(true);
        this.infoLabel.setEditable(false);
        this.infoLabel.setBackground(this.getContentPane().getBackground());
        Dimension base = new Dimension(400, 100);
        this.infoLabel.setPreferredSize(base);
        this.save = new JButton("Save");
        this.save.addActionListener(this);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(this);
        JPanel editingPanel = new JPanel();
        JPanel buttonPanel = new JPanel();
        JPanel centerPanel = new JPanel();
        editingPanel.setBackground(blue);
        editingPanel.setLayout(new GridLayout(this.inputBoxLabels.length, 2, 6, 11));
        int i2 = 0;
        while (i2 < this.inputBoxLabels.length) {
            editingPanel.add(this.inputBoxes[i2]);
            editingPanel.add(this.inputBoxLabels[i2]);
            ++i2;
        }
        this.setLayout(new BorderLayout());
        this.add((Component)editingPanel, "North");
        buttonPanel.setBackground(blue);
        buttonPanel.setLayout(new GridLayout(1, 2, 6, 11));
        buttonPanel.add(this.save);
        buttonPanel.add(this.cancel);
        this.add((Component)buttonPanel, "South");
        centerPanel.setBackground(blue);
        centerPanel.setLayout(new BorderLayout());
        centerPanel.add((Component)this.descriptionTitle, "North");
        centerPanel.add((Component)this.infoLabel, "Center");
        this.add((Component)centerPanel, "Center");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.cancel)) {
            this.cancel();
        } else if (e.getSource().equals(this.save)) {
            this.save();
        }
    }

    private void cancel() {
        this.setVisible(false);
    }

    private void save() {
        boolean good = true;
        int i = 0;
        while (i < this.inputBoxes.length) {
            try {
                this.fe_.setElement(i, this.inputBoxes[i].getText());
            }
            catch (Exception e) {
                good = false;
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
            }
            ++i;
        }
        if (good) {
            this.setVisible(false);
        }
    }

    void setRow(int i) {
        this.row = i;
    }
}

