/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.GeneralTools;

import jAudioFeatureExtractor.GeneralTools.GeneralMethods;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;

public class StringMethods {
    public static String convertFilePathToFileName(String file_path) {
        return file_path.substring(file_path.lastIndexOf(File.separator) + 1, file_path.length());
    }

    public static String getDirectoryName(String file_path) throws Exception {
        int index_of_last_separator = file_path.lastIndexOf(File.separatorChar);
        if (index_of_last_separator == -1) {
            throw new Exception(String.valueOf(file_path) + " does not contain a valid directory separator.");
        }
        return new String(String.valueOf(file_path.substring(0, file_path.lastIndexOf(File.separator))) + File.separator);
    }

    public static String removeExtension(String filename) {
        if (filename.length() < 5) {
            return null;
        }
        if (filename.charAt(filename.length() - 4) != '.') {
            if (filename.charAt(filename.length() - 5) == '.') {
                return filename.substring(0, filename.length() - 5);
            }
            if (filename.charAt(filename.length() - 3) == '.') {
                return filename.substring(0, filename.length() - 3);
            }
            return null;
        }
        return filename.substring(0, filename.length() - 4);
    }

    public static String getExtension(String filename) {
        if (filename.length() < 5) {
            return null;
        }
        if (filename.charAt(filename.length() - 4) != '.') {
            if (filename.charAt(filename.length() - 5) == '.') {
                return filename.substring(filename.length() - 5, filename.length());
            }
            if (filename.charAt(filename.length() - 3) == '.') {
                return filename.substring(filename.length() - 3, filename.length());
            }
            return null;
        }
        return filename.substring(filename.length() - 4, filename.length());
    }

    public static String getBeginningOfString(String string_to_shorten, int number_characters) {
        String copy = new String(string_to_shorten);
        if (string_to_shorten.length() < number_characters) {
            int difference = number_characters - string_to_shorten.length();
            int i = 0;
            while (i < difference) {
                copy = String.valueOf(copy) + " ";
                ++i;
            }
            return copy;
        }
        if (string_to_shorten.length() > number_characters) {
            return string_to_shorten.substring(0, number_characters);
        }
        return copy;
    }

    public static String getBeginningOfStringWithHyphenFiller(String string_to_shorten, int number_characters) {
        String copy = new String(string_to_shorten);
        if (string_to_shorten.length() < number_characters) {
            int difference = number_characters - string_to_shorten.length();
            int i = 0;
            while (i < difference) {
                copy = i == 0 || i == 1 || i == difference - 2 || i == difference - 1 ? String.valueOf(copy) + " " : String.valueOf(copy) + "-";
                ++i;
            }
            return copy;
        }
        if (string_to_shorten.length() > number_characters) {
            return string_to_shorten.substring(0, number_characters);
        }
        return copy;
    }

    public static String getDoubleInScientificNotation(double number_to_round, int significant_digits) {
        if (Double.isNaN(number_to_round)) {
            return new String("NaN");
        }
        if (Double.isInfinite(number_to_round)) {
            return new String("Infinity");
        }
        String format_pattern = "0.";
        int i = 0;
        while (i < significant_digits - 1) {
            format_pattern = String.valueOf(format_pattern) + "#";
            ++i;
        }
        format_pattern = String.valueOf(format_pattern) + "E0";
        NumberFormat formatter = NumberFormat.getInstance(Locale.ENGLISH);
        DecimalFormat decimal_formatter = (DecimalFormat)formatter;
        decimal_formatter.applyPattern(format_pattern);
        return decimal_formatter.format(number_to_round);
    }

    public static String getRoundedDouble(double number_to_round, int decimal_places) {
        if (number_to_round == Double.NaN) {
            return new String("NaN");
        }
        if (number_to_round == Double.NEGATIVE_INFINITY) {
            return new String("-Infinity");
        }
        if (number_to_round == Double.POSITIVE_INFINITY) {
            return new String("Infinity");
        }
        String format_pattern = "#0.";
        int i = 0;
        while (i < decimal_places) {
            format_pattern = String.valueOf(format_pattern) + "#";
            ++i;
        }
        DecimalFormat formatter = new DecimalFormat(format_pattern);
        return formatter.format(number_to_round);
    }

    public static int getIndexOfString(String given_name, String[] possible_names) throws Exception {
        int i = 0;
        while (i < possible_names.length) {
            if (given_name.equals(possible_names[i])) {
                return i;
            }
            ++i;
        }
        throw new Exception("Unable to find " + given_name + ".");
    }

    public static String[] removeDoubles(String[] strings) {
        Object[] editable_strings = new String[strings.length];
        int i = 0;
        while (i < editable_strings.length) {
            editable_strings[i] = strings[i];
            ++i;
        }
        i = 0;
        while (i < editable_strings.length - 1) {
            int j = i + 1;
            while (j < editable_strings.length) {
                if (editable_strings[i] != null && editable_strings[j] != null && ((String)editable_strings[i]).equals(editable_strings[j])) {
                    editable_strings[j] = null;
                }
                ++j;
            }
            ++i;
        }
        Object[] cleaned_obj = GeneralMethods.removeNullEntriesFromArray(editable_strings);
        String[] cleaned_strings = new String[cleaned_obj.length];
        int i2 = 0;
        while (i2 < cleaned_strings.length) {
            cleaned_strings[i2] = (String)cleaned_obj[i2];
            ++i2;
        }
        return cleaned_strings;
    }
}

