/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import jAudioFeatureExtractor.jAudioTools.AudioFormatJFrame;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsSynthesis;
import jAudioFeatureExtractor.jAudioTools.FileFilterAudio;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.SourceDataLine;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class SynthesisFrame
extends JFrame
implements ActionListener {
    static final long serialVersionUID = 1L;
    private SynthesisParameters selected_components;
    private AudioMethodsPlayback.PlayThread playback_thread;
    Controller controller;
    private AudioFormatJFrame audio_format_selector;
    private JFileChooser save_file_chooser;
    private JComboBox synthesis_selection_combo_box;
    private JTextArea fund_freq_text_area;
    private JTextArea relative_amplitude_multiplier_text_area;
    private JTextArea max_fraction_of_sampling_rate_text_area;
    private JTextArea selected_components_text_area;
    private JScrollPane selected_components_scroll_pane;
    private JTextArea duration_text_area;
    private JTextArea gain_text_area;
    private JTextArea panning_text_area;
    private JTextArea click_avoid_env_length_text_area;
    private JButton choose_encoding_format_button;
    private JButton add_synthesis_component_button;
    private JButton clear_synthesis_components_button;
    private JButton play_button;
    private JButton stop_playback_button;
    private JButton save_button;
    private JButton cancel_button;
    private JComboBox choose_file_format_combo_box;

    public SynthesisFrame(Controller c) {
        this.setTitle("Synthesize Audio");
        this.getContentPane().setBackground(new Color(0.75f, 0.85f, 1.0f));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SynthesisFrame.this.cancel();
            }
        });
        this.selected_components = null;
        this.playback_thread = null;
        this.save_file_chooser = null;
        this.controller = c;
        this.audio_format_selector = new AudioFormatJFrame();
        AudioFormat default_format = AudioFormatJFrame.getStandardMidQualityRecordAudioFormat();
        this.audio_format_selector.setAudioFormat(default_format);
        String[] synthesis_types = AudioMethodsSynthesis.getSynthesisNames();
        this.synthesis_selection_combo_box = new JComboBox<String>(synthesis_types);
        this.synthesis_selection_combo_box.setBackground(this.getContentPane().getBackground());
        this.fund_freq_text_area = new JTextArea("440.0");
        this.relative_amplitude_multiplier_text_area = new JTextArea("1.0");
        this.max_fraction_of_sampling_rate_text_area = new JTextArea("0.45");
        this.duration_text_area = new JTextArea("1.0");
        this.gain_text_area = new JTextArea("0.8");
        this.panning_text_area = new JTextArea("0.0");
        this.click_avoid_env_length_text_area = new JTextArea("0.05");
        this.selected_components_text_area = new JTextArea();
        this.selected_components_text_area.setEditable(false);
        this.selected_components_text_area.setLineWrap(false);
        this.selected_components_text_area.setRows(4);
        this.selected_components_scroll_pane = new JScrollPane(this.selected_components_text_area);
        this.choose_encoding_format_button = new JButton("Choose Audio Format");
        this.choose_encoding_format_button.addActionListener(this);
        this.add_synthesis_component_button = new JButton("Add Component");
        this.add_synthesis_component_button.addActionListener(this);
        this.clear_synthesis_components_button = new JButton("Clear All Components");
        this.clear_synthesis_components_button.addActionListener(this);
        this.play_button = new JButton("Play");
        this.play_button.addActionListener(this);
        this.stop_playback_button = new JButton("Stop Playback");
        this.stop_playback_button.addActionListener(this);
        this.save_button = new JButton("Save");
        this.save_button.addActionListener(this);
        this.cancel_button = new JButton("Cancel");
        this.cancel_button.addActionListener(this);
        this.choose_file_format_combo_box = new JComboBox();
        String[] file_types = AudioMethods.getAvailableFileFormatTypes();
        int i = 0;
        while (i < file_types.length) {
            this.choose_file_format_combo_box.addItem(file_types[i]);
            ++i;
        }
        this.choose_file_format_combo_box.setBackground(this.getContentPane().getBackground());
        int horizontal_gap = 6;
        int vertical_gap = 11;
        this.setLayout(new BorderLayout(horizontal_gap, vertical_gap));
        JPanel selections_panel = new JPanel(new GridLayout(13, 2, horizontal_gap, vertical_gap));
        selections_panel.setBackground(this.getContentPane().getBackground());
        JPanel report_panel = new JPanel(new BorderLayout(horizontal_gap, vertical_gap));
        report_panel.setBackground(this.getContentPane().getBackground());
        JPanel buttons_panel = new JPanel(new GridLayout(4, 2, horizontal_gap, vertical_gap));
        buttons_panel.setBackground(this.getContentPane().getBackground());
        selections_panel.add(new JLabel("OVERALL SYNTHESIS:"));
        selections_panel.add(new JLabel(""));
        selections_panel.add(new JLabel("Synthesis Encoding Format:"));
        selections_panel.add(this.choose_encoding_format_button);
        selections_panel.add(new JLabel("Duration (sec):"));
        selections_panel.add(this.duration_text_area);
        selections_panel.add(new JLabel("Gain (0.0 to 1.0):"));
        selections_panel.add(this.gain_text_area);
        selections_panel.add(new JLabel("Panning (-1.0 to 1.0):"));
        selections_panel.add(this.panning_text_area);
        selections_panel.add(new JLabel("Click Avoidance Env. Length (sec):"));
        selections_panel.add(this.click_avoid_env_length_text_area);
        selections_panel.add(new JLabel(""));
        selections_panel.add(new JLabel(""));
        selections_panel.add(new JLabel("INDIVIDUAL COMPONENTS:"));
        selections_panel.add(new JLabel(""));
        selections_panel.add(new JLabel("Synthesis Type:"));
        selections_panel.add(this.synthesis_selection_combo_box);
        selections_panel.add(new JLabel("Fundamental Frequency (Hz):"));
        selections_panel.add(this.fund_freq_text_area);
        selections_panel.add(new JLabel("Relative Amplitude (0.0 to 1.0):"));
        selections_panel.add(this.relative_amplitude_multiplier_text_area);
        selections_panel.add(new JLabel("Max Fraction of Sampling Rate:"));
        selections_panel.add(this.max_fraction_of_sampling_rate_text_area);
        selections_panel.add(this.clear_synthesis_components_button);
        selections_panel.add(this.add_synthesis_component_button);
        report_panel.add(this.selected_components_scroll_pane);
        buttons_panel.add(this.play_button);
        buttons_panel.add(this.stop_playback_button);
        buttons_panel.add(new JLabel("File Format For Saving:"));
        buttons_panel.add(this.choose_file_format_combo_box);
        buttons_panel.add(new JLabel(""));
        buttons_panel.add(new JLabel(""));
        buttons_panel.add(this.cancel_button);
        buttons_panel.add(this.save_button);
        this.add((Component)selections_panel, "North");
        this.add((Component)report_panel, "Center");
        this.add((Component)buttons_panel, "South");
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.choose_encoding_format_button)) {
            this.audio_format_selector.setVisible(true);
        } else if (event.getSource().equals(this.add_synthesis_component_button)) {
            this.addSynthesisComponent();
        } else if (event.getSource().equals(this.clear_synthesis_components_button)) {
            this.clearSynthesisComponents();
        } else if (event.getSource().equals(this.play_button)) {
            this.play();
        } else if (event.getSource().equals(this.stop_playback_button)) {
            this.stopPlayback();
        } else if (event.getSource().equals(this.save_button)) {
            this.save();
        } else if (event.getSource().equals(this.cancel_button)) {
            this.cancel();
        }
    }

    private void play() {
        try {
            if (this.playback_thread != null) {
                this.stopPlayback();
            }
            byte[] audio_data = this.performAdditiveSynthesis();
            AudioFormat audio_format = this.audio_format_selector.getAudioFormat(false);
            AudioInputStream audio_input_stream = AudioMethods.getInputStream(audio_data, audio_format);
            SourceDataLine source_data_line = AudioMethods.getSourceDataLine(audio_format, null);
            this.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audio_input_stream, source_data_line);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void stopPlayback() {
        if (this.playback_thread != null) {
            this.playback_thread.stopPlaying();
            this.playback_thread = null;
        }
    }

    private void save() {
        if (this.playback_thread != null) {
            this.stopPlayback();
        }
        try {
            int dialog_result;
            byte[] audio_data = this.performAdditiveSynthesis();
            AudioFormat audio_format = this.audio_format_selector.getAudioFormat(false);
            AudioInputStream audio_input_stream = AudioMethods.getInputStream(audio_data, audio_format);
            if (this.save_file_chooser == null) {
                this.save_file_chooser = new JFileChooser();
                this.save_file_chooser.setCurrentDirectory(new File("."));
                this.save_file_chooser.setFileFilter(new FileFilterAudio());
            }
            if ((dialog_result = this.save_file_chooser.showSaveDialog(this)) == 0) {
                int overwrite;
                File save_file = this.save_file_chooser.getSelectedFile();
                boolean proceed = true;
                String correct_format_name = (String)this.choose_file_format_combo_box.getSelectedItem();
                AudioFileFormat.Type correct_format = AudioMethods.getAudioFileFormatType(correct_format_name);
                if ((save_file = this.ensureCorrectExtension(save_file, correct_format)).exists() && (overwrite = JOptionPane.showConfirmDialog(null, "This file already exists.\nDo you wish to overwrite it?", "WARNING", 0)) != 0) {
                    proceed = false;
                }
                if (proceed) {
                    try {
                        AudioMethods.saveToFile(audio_input_stream, save_file, correct_format);
                        File[] to_add_to_table = new File[]{save_file};
                        this.controller.addRecordingsAction.addRecording(to_add_to_table);
                        this.cancel();
                    }
                    catch (Exception e) {
                        JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                    }
                }
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void cancel() {
        this.stopPlayback();
        this.setVisible(false);
    }

    private void addSynthesisComponent() {
        String synthesis_type_name = (String)this.synthesis_selection_combo_box.getSelectedItem();
        double fundamental_frequency = Double.parseDouble(this.fund_freq_text_area.getText());
        double relative_amplitude = Double.parseDouble(this.relative_amplitude_multiplier_text_area.getText());
        double max_allowable_fraction_of_sampling_rate = Double.parseDouble(this.max_fraction_of_sampling_rate_text_area.getText());
        try {
            if (this.selected_components == null) {
                this.selected_components = new SynthesisParameters(synthesis_type_name, fundamental_frequency, relative_amplitude, max_allowable_fraction_of_sampling_rate);
            } else {
                SynthesisParameters temp = this.selected_components;
                while (temp.next_set_of_parameters != null) {
                    temp = temp.next_set_of_parameters;
                }
                temp.next_set_of_parameters = new SynthesisParameters(synthesis_type_name, fundamental_frequency, relative_amplitude, max_allowable_fraction_of_sampling_rate);
            }
            this.selected_components_text_area.append(String.valueOf(synthesis_type_name) + " " + fundamental_frequency + " Hz " + relative_amplitude + " rel. amp " + max_allowable_fraction_of_sampling_rate + " max. frac. SR\n");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
        }
    }

    private void clearSynthesisComponents() {
        this.selected_components_text_area.setText("");
        this.selected_components = null;
    }

    private byte[] performAdditiveSynthesis() throws Exception {
        AudioFormat audio_format = this.audio_format_selector.getAudioFormat(false);
        double gain = Double.parseDouble(this.gain_text_area.getText());
        double panning = Double.parseDouble(this.panning_text_area.getText());
        double duration = Double.parseDouble(this.duration_text_area.getText());
        double click_avoid_env_length = Double.parseDouble(this.click_avoid_env_length_text_area.getText());
        if (duration > 7200.0) {
            throw new Exception("You have selected a duration of " + duration + " seconds,\n" + "which is too long. Duration must be less than 2 hours.");
        }
        if (duration <= 0.0) {
            throw new Exception("You have selected a duration of " + duration + "seconds.\n" + "Duration must be over seconds.");
        }
        int number_components = 0;
        double total_multipliers = 0.0;
        if (this.selected_components == null) {
            throw new Exception("No additive synthesis components have been added yet.");
        }
        SynthesisParameters temp = this.selected_components;
        while (temp.next_set_of_parameters != null) {
            ++number_components;
            total_multipliers += temp.relative_amplitude;
            temp = temp.next_set_of_parameters;
        }
        total_multipliers += temp.relative_amplitude;
        double[] multipliers = new double[++number_components];
        SynthesisParameters temp2 = this.selected_components;
        int i = 0;
        while (i < number_components) {
            multipliers[i] = temp2.relative_amplitude / total_multipliers;
            temp2 = temp2.next_set_of_parameters;
            ++i;
        }
        double[][][] components = new double[number_components][][];
        temp2 = this.selected_components;
        int comp = 0;
        while (comp < number_components) {
            int synthesis_type_code = AudioMethodsSynthesis.getSynthesisTypeCode(temp2.synthesis_type);
            components[comp] = AudioMethodsSynthesis.synthesizeAndWriteToBuffer(null, duration, audio_format, synthesis_type_code, gain, panning, temp2.fundamental_frequency, temp2.max_fraction_of_sampling_rate, click_avoid_env_length);
            temp2 = temp2.next_set_of_parameters;
            ++comp;
        }
        double[][] combined_components = new double[components[0].length][components[0][0].length];
        int chan = 0;
        while (chan < combined_components.length) {
            int samp = 0;
            while (samp < combined_components[chan].length) {
                combined_components[chan][samp] = 0.0;
                ++samp;
            }
            ++chan;
        }
        int samp = 0;
        while (samp < combined_components[0].length) {
            int comp2 = 0;
            while (comp2 < components.length) {
                int chan2 = 0;
                while (chan2 < combined_components.length) {
                    double[] dArray = combined_components[chan2];
                    int n = samp;
                    dArray[n] = dArray[n] + multipliers[comp2] * components[comp2][chan2][samp];
                    ++chan2;
                }
                ++comp2;
            }
            ++samp;
        }
        int number_bytes_needed = AudioMethods.getNumberBytesNeeded(combined_components[0].length, audio_format);
        byte[] audio_data = new byte[number_bytes_needed];
        AudioMethodsSynthesis.writeSamplesToBuffer(combined_components, audio_format.getSampleSizeInBits(), audio_data);
        return audio_data;
    }

    private File ensureCorrectExtension(File file_to_verify, AudioFileFormat.Type file_format_type) {
        String correct_extension = "." + file_format_type.getExtension();
        String path = file_to_verify.getAbsolutePath();
        String ext = StringMethods.getExtension(path);
        if (ext == null) {
            path = String.valueOf(path) + correct_extension;
        } else if (!ext.equals(correct_extension)) {
            path = String.valueOf(StringMethods.removeExtension(path)) + correct_extension;
        } else {
            return file_to_verify;
        }
        JOptionPane.showMessageDialog(null, "Incorrect file extension specified.\nChanged from " + ext + " to " + correct_extension + ".", "WARNING", 0);
        return new File(path);
    }

    private class SynthesisParameters {
        public String synthesis_type;
        public double fundamental_frequency;
        public double relative_amplitude;
        public double max_fraction_of_sampling_rate;
        public SynthesisParameters next_set_of_parameters;

        public SynthesisParameters(String synthesis_type, double fundamental_frequency, double relative_amplitude, double max_fraction_of_sampling_rate) throws Exception {
            String[] synthesis_types = AudioMethodsSynthesis.getSynthesisNames();
            boolean type_ok = false;
            int i = 0;
            while (i < synthesis_types.length) {
                if (synthesis_types[i].equals(synthesis_type)) {
                    type_ok = true;
                }
                ++i;
            }
            if (!type_ok) {
                throw new Exception("Synthesis type " + synthesis_type + " is unknown.");
            }
            if (fundamental_frequency <= 0.0) {
                throw new Exception("Fundamental frequency is " + fundamental_frequency + ".\n" + "This value must be above zero.");
            }
            if (relative_amplitude < 0.0 || relative_amplitude > 1.0) {
                throw new Exception("Relative amplitude is " + relative_amplitude + ".\n" + "This value must be between 0 and 1.");
            }
            if (max_fraction_of_sampling_rate <= 0.0) {
                throw new Exception("Maximum fraction of sampling rate is " + max_fraction_of_sampling_rate + ",\n" + "This value must be above zero.");
            }
            this.synthesis_type = synthesis_type;
            this.fundamental_frequency = fundamental_frequency;
            this.relative_amplitude = relative_amplitude;
            this.max_fraction_of_sampling_rate = max_fraction_of_sampling_rate;
            this.next_set_of_parameters = null;
        }
    }
}

