/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.AddBatchGUI;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Controller;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class AddBatchAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private JTextArea window_length_text_field;
    private JTextArea window_overlap_fraction_text_field;
    private JCheckBox save_window_features_check_box;
    private JCheckBox save_overall_file_featurese_check_box;
    private JTextArea destinationFV;
    private JTextArea destinationFK;
    private Controller controller;
    private AddBatchGUI addBatchGUI;

    public AddBatchAction(Controller c) {
        super("Define Batch");
        this.controller = c;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Batch b = new Batch();
        boolean good = true;
        LinkedList<File> filesL = new LinkedList<File>();
        int i = 0;
        while (i < this.controller.rtm_.getRowCount()) {
            filesL.add(new File((String)this.controller.rtm_.getValueAt(i, 1)));
            ++i;
        }
        File[] files = filesL.toArray(new File[0]);
        if (files.length == 0) {
            JOptionPane.showMessageDialog(null, "Batches must contain files to record.  Add files to recording table.", "ERROR", 0);
            good = false;
        }
        try {
            b.setRecordings(files);
        }
        catch (Exception e1) {
            good = false;
            JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
        }
        b.setDataModel(this.controller.dm_);
        HashMap<String, Boolean> active = new HashMap<String, Boolean>();
        HashMap<String, String[]> attributes = new HashMap<String, String[]>();
        LinkedList<String> tmpAttributes = new LinkedList<String>();
        int i2 = 0;
        while (i2 < this.controller.dm_.features.length) {
            String name = this.controller.dm_.features[i2].getFeatureDefinition().name;
            active.put(name, (Boolean)this.controller.fstm_.getValueAt(i2, 0));
            int count = this.controller.dm_.features[i2].getFeatureDefinition().attributes.length;
            int j = 0;
            while (j < count) {
                try {
                    tmpAttributes.add(this.controller.dm_.features[i2].getElement(j));
                }
                catch (Exception e1) {
                    good = false;
                    JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
                    e1.printStackTrace();
                }
                ++j;
            }
            attributes.put(name, tmpAttributes.toArray(new String[0]));
            tmpAttributes.clear();
            ++i2;
        }
        b.setFeatures(active, attributes);
        int windowLength = 512;
        double windowOverlap = 0.0;
        try {
            windowLength = Integer.parseInt(this.window_length_text_field.getText());
        }
        catch (NumberFormatException e1) {
            good = false;
            JOptionPane.showMessageDialog(null, "window length must be an integer", "ERROR", 0);
        }
        try {
            windowOverlap = Double.parseDouble(this.window_overlap_fraction_text_field.getText());
        }
        catch (NumberFormatException e1) {
            good = false;
            JOptionPane.showMessageDialog(null, "window overlap must be a double", "ERROR", 0);
        }
        if (windowOverlap < 0.0 || windowOverlap >= 1.0) {
            good = false;
            JOptionPane.showMessageDialog(null, "Window Overlap must be equal or greater than 0 and less than 1.0", "ERROR", 0);
        }
        if (windowLength <= 0) {
            good = false;
            JOptionPane.showMessageDialog(null, "Window length must be greater than 0", "ERROR", 0);
        }
        Aggregator[] aggs = this.controller.dm_.aggregators;
        String[] names = new String[aggs.length];
        String[][] features = new String[aggs.length][];
        String[][] parameters = new String[aggs.length][];
        int i3 = 0;
        while (i3 < aggs.length) {
            names[i3] = aggs[i3].getAggregatorDefinition().name;
            features[i3] = aggs[i3].getFeaturesToApply();
            parameters[i3] = aggs[i3].getParamaters();
            ++i3;
        }
        b.setAggregators(names, features, parameters);
        b.setSettings(windowLength, windowOverlap, this.controller.samplingRateAction.getSamplingRate(), this.controller.normalise.isSelected(), this.save_window_features_check_box.isSelected(), this.save_overall_file_featurese_check_box.isSelected(), this.controller.outputTypeAction.getSelected());
        b.setDestination(this.destinationFK.getText(), this.destinationFV.getText());
        if (good) {
            this.addBatchGUI = new AddBatchGUI(this.controller, b);
        } else {
            JOptionPane.showMessageDialog(null, "Batch creation failed", "ERROR", 0);
        }
    }

    public void setSettings(JCheckBox saveWindow, JCheckBox overall, JTextArea windowLength, JTextArea windowOverlap) {
        this.save_window_features_check_box = saveWindow;
        this.save_overall_file_featurese_check_box = overall;
        this.window_length_text_field = windowLength;
        this.window_overlap_fraction_text_field = windowOverlap;
    }

    public void setFilePath(JTextArea FV, JTextArea FK) {
        this.destinationFV = FV;
        this.destinationFK = FK;
    }
}

