/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import jAudioFeatureExtractor.GeneralTools.GeneralMethods;
import jAudioFeatureExtractor.jAudioTools.AudioSamples;
import jAudioFeatureExtractor.jAudioTools.FileFilterAudio;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class AddRecordingAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private JFileChooser load_recording_chooser = null;
    private Controller controller;

    public AddRecordingAction() {
        super("Add Recording...");
    }

    public void setModel(Controller c) {
        this.controller = c;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int dialog_result;
        if (this.load_recording_chooser == null) {
            this.load_recording_chooser = new JFileChooser();
            this.load_recording_chooser.setCurrentDirectory(new File("."));
            this.load_recording_chooser.setFileFilter(new FileFilterAudio());
            this.load_recording_chooser.setFileSelectionMode(0);
            this.load_recording_chooser.setMultiSelectionEnabled(true);
        }
        if ((dialog_result = this.load_recording_chooser.showOpenDialog(null)) == 0) {
            File[] load_files = this.load_recording_chooser.getSelectedFiles();
            try {
                this.addRecording(load_files);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    public void addRecording(File[] toBeAdded) throws Exception {
        RecordingInfo[] recording_info = new RecordingInfo[toBeAdded.length];
        int i = 0;
        while (i < toBeAdded.length) {
            recording_info[i] = null;
            if (toBeAdded[i].exists()) {
                try {
                    AudioSamples audio_samples = null;
                    if (this.controller.validate.isSelected()) {
                        audio_samples = new AudioSamples(toBeAdded[i], toBeAdded[i].getPath(), false);
                    }
                    if (this.controller.storeSamples.isSelected()) {
                        if (audio_samples == null) {
                            audio_samples = new AudioSamples(toBeAdded[i], toBeAdded[i].getPath(), false);
                        }
                    } else {
                        audio_samples = null;
                    }
                    recording_info[i] = new RecordingInfo(toBeAdded[i].getName(), toBeAdded[i].getPath(), audio_samples, false);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, e.getMessage(), "ERROR", 0);
                }
            } else {
                JOptionPane.showMessageDialog(null, "The selected file " + toBeAdded[i].getName() + " does not exist.", "ERROR", 0);
            }
            ++i;
        }
        int number_old_recordings = 0;
        if (this.controller.dm_.recordingInfo != null) {
            number_old_recordings = this.controller.dm_.recordingInfo.length;
        }
        int number_new_recordings = 0;
        number_new_recordings = recording_info.length;
        Object[] temp_recording_list = new RecordingInfo[number_old_recordings + number_new_recordings];
        int i2 = 0;
        while (i2 < number_old_recordings) {
            temp_recording_list[i2] = this.controller.dm_.recordingInfo[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < number_new_recordings) {
            temp_recording_list[i2 + number_old_recordings] = recording_info[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < temp_recording_list.length - 1) {
            if (temp_recording_list[i2] != null) {
                String current_path = ((RecordingInfo)temp_recording_list[i2]).file_path;
                int j = i2 + 1;
                while (j < temp_recording_list.length) {
                    if (temp_recording_list[j] != null && current_path.equals(((RecordingInfo)temp_recording_list[j]).file_path)) {
                        temp_recording_list[j] = null;
                    }
                    ++j;
                }
            }
            ++i2;
        }
        Object[] results = GeneralMethods.removeNullEntriesFromArray(temp_recording_list);
        if (results != null) {
            this.controller.dm_.recordingInfo = new RecordingInfo[results.length];
            int i3 = 0;
            while (i3 < results.length) {
                this.controller.dm_.recordingInfo[i3] = (RecordingInfo)results[i3];
                ++i3;
            }
        }
        this.controller.rtm_.fillTable(this.controller.dm_.recordingInfo);
        this.controller.rtm_.fireTableDataChanged();
    }
}

