/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.ACE.XMLParsers.FileFilterXML;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.Aggregators.Aggregator;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.FeatureSelectorTableModel;
import jAudioFeatureExtractor.GeneralTools.StringMethods;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public class LoadAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private JTextArea window_length_text_field;
    private JTextArea window_overlap_fraction_text_field;
    private JCheckBox save_window_features_check_box;
    private JCheckBox save_overall_file_featurese_check_box;
    private FeatureSelectorTableModel fstm_;
    private JFileChooser save_file_chooser = null;
    private Controller controller;

    public LoadAction(Controller c, FeatureSelectorTableModel fstm) {
        super("Load Settings...");
        this.fstm_ = fstm;
        this.controller = c;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.save_file_chooser == null) {
            this.save_file_chooser = new JFileChooser();
            this.save_file_chooser.setCurrentDirectory(new File("."));
            this.save_file_chooser.setFileFilter(new FileFilterXML());
        }
        String path = null;
        int dialog_result = this.save_file_chooser.showOpenDialog(null);
        if (dialog_result == 0) {
            File to_save_to = this.save_file_chooser.getSelectedFile();
            path = to_save_to.getPath();
            String ext = StringMethods.getExtension(path);
            if (ext == null) {
                path = String.valueOf(path) + ".xml";
                to_save_to = new File(path);
            } else if (!ext.equals(".xml")) {
                path = String.valueOf(StringMethods.removeExtension(path)) + ".xml";
                to_save_to = new File(path);
            }
            if (!to_save_to.exists()) {
                JOptionPane.showMessageDialog(null, "The file '" + to_save_to.getName() + "' does not exist", "ERROR", 0);
            } else {
                try {
                    Object[] tmp = (Object[])XMLDocumentParser.parseXMLDocument(path, "save_settings");
                    this.window_length_text_field.setText((String)tmp[0]);
                    this.window_overlap_fraction_text_field.setText((String)tmp[1]);
                    double rate = (Double)tmp[2];
                    if (rate <= 8000.0) {
                        this.controller.samplingRateAction.setSelected(0);
                    } else if (rate <= 11025.0) {
                        this.controller.samplingRateAction.setSelected(1);
                    } else if (rate <= 16000.0) {
                        this.controller.samplingRateAction.setSelected(2);
                    } else if (rate <= 22050.0) {
                        this.controller.samplingRateAction.setSelected(3);
                    } else {
                        this.controller.samplingRateAction.setSelected(4);
                    }
                    this.controller.normalise.setSelected((Boolean)tmp[3]);
                    this.save_window_features_check_box.setSelected((Boolean)tmp[4]);
                    this.save_overall_file_featurese_check_box.setSelected((Boolean)tmp[5]);
                    if (tmp[6].equals("ACE")) {
                        this.controller.outputTypeAction.setSelected(0);
                    } else {
                        this.controller.outputTypeAction.setSelected(1);
                    }
                    HashMap checked = (HashMap)tmp[7];
                    HashMap featureAttributes = (HashMap)tmp[8];
                    int i = 0;
                    while (i < this.fstm_.getRowCount()) {
                        String name = (String)this.fstm_.getValueAt(i, 1);
                        if (featureAttributes.containsKey(name) && checked.containsKey(name)) {
                            this.fstm_.setValueAt(checked.get(name), i, 0);
                            String[] fa = (String[])featureAttributes.get(name);
                            int j = 0;
                            while (j < fa.length) {
                                this.controller.dm_.features[i].setElement(j, fa[j]);
                                ++j;
                            }
                        } else {
                            this.fstm_.setValueAt(Boolean.FALSE, i, 0);
                        }
                        ++i;
                    }
                    this.fstm_.fireTableDataChanged();
                    LinkedList aggNames = (LinkedList)tmp[9];
                    LinkedList aggFeatures = (LinkedList)tmp[10];
                    LinkedList aggParameters = (LinkedList)tmp[11];
                    LinkedList<Aggregator> dest = new LinkedList<Aggregator>();
                    Iterator names_it = aggNames.iterator();
                    Iterator features_it = aggFeatures.iterator();
                    Iterator parameters_it = aggParameters.iterator();
                    while (names_it.hasNext()) {
                        Aggregator agg = this.controller.dm_.aggregatorMap.get(names_it.next());
                        agg.setParameters((String[])features_it.next(), (String[])parameters_it.next());
                        dest.add(agg);
                    }
                    this.controller.dm_.aggregators = dest.toArray(new Aggregator[0]);
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
                }
            }
        }
    }

    public void setObjectReferences(JTextArea win_length, JTextArea win_overlap, JCheckBox save_window, JCheckBox save_overall) {
        this.window_length_text_field = win_length;
        this.window_overlap_fraction_text_field = win_overlap;
        this.save_window_features_check_box = save_window;
        this.save_overall_file_featurese_check_box = save_overall;
    }
}

