/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.ACE.XMLParsers.XMLDocumentParser;
import jAudioFeatureExtractor.Controller;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class LoadBatchAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    Controller controller;

    public LoadBatchAction(Controller c) {
        super("Load Batchfile...");
        this.controller = c;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser chooser = new JFileChooser();
        int state = chooser.showOpenDialog(null);
        File file = chooser.getSelectedFile();
        if (file != null && state == 0) {
            try {
                this.controller.batches.clear();
                Object[] retList = (Object[])XMLDocumentParser.parseXMLDocument(file.getAbsolutePath(), "batchFile");
                int i = 0;
                while (i < retList.length) {
                    this.controller.batches.add((Batch)retList[i]);
                    this.controller.batches.get(i).setDataModel(this.controller.dm_);
                    JMenuItem remove = new JMenuItem(this.controller.batches.get(i).getName());
                    remove.addActionListener(this.controller.removeBatchAction);
                    this.controller.removeBatch.add(remove);
                    JMenuItem view = new JMenuItem(this.controller.batches.get(i).getName());
                    view.addActionListener(this.controller.viewBatchAction);
                    this.controller.viewBatch.add(view);
                    ++i;
                }
                if (this.controller.batches.size() > 0) {
                    this.controller.removeBatch.setEnabled(true);
                    this.controller.viewBatch.setEnabled(true);
                }
                JOptionPane.showMessageDialog(null, "Loading of batch file successful.", "Information", 1);
            }
            catch (Exception e1) {
                JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
            }
        }
    }
}

