/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.jAudioTools.AudioMethods;
import jAudioFeatureExtractor.jAudioTools.AudioMethodsPlayback;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class PlayNowAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private Controller controller;
    private JTable recordings_table;

    public PlayNowAction(Controller c) {
        super("Play From File...");
        this.controller = c;
    }

    public void setTable(JTable recordings_table) {
        this.recordings_table = recordings_table;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            int selected_row = this.recordings_table.getSelectedRow();
            if (selected_row < 0) {
                throw new Exception("No file selcected for playback.");
            }
            File play_file = new File(this.controller.dm_.recordingInfo[selected_row].file_path);
            try {
                AudioInputStream audio_input_stream = AudioSystem.getAudioInputStream(play_file);
                audio_input_stream = AudioMethods.convertUnsupportedFormat(audio_input_stream);
                SourceDataLine source_data_line = AudioMethods.getSourceDataLine(audio_input_stream.getFormat(), null);
                this.controller.stopPlayBackAction.stopPlayback();
                this.controller.dm_.playback_thread = AudioMethodsPlayback.playAudioInputStreamInterruptible(audio_input_stream, source_data_line);
            }
            catch (UnsupportedAudioFileException ex) {
                throw new Exception("File " + play_file.getName() + " has an unsupported audio format.");
            }
            catch (Exception ex) {
                throw new Exception("File " + play_file.getName() + " is not playable.\n" + ex.getMessage());
            }
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, ex.getMessage(), "ERROR", 0);
        }
    }
}

