/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.actions;

import jAudioFeatureExtractor.ACE.DataTypes.Batch;
import jAudioFeatureExtractor.Controller;
import jAudioFeatureExtractor.DataTypes.RecordingInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextArea;

public class ViewBatchAction
extends AbstractAction {
    static final long serialVersionUID = 1L;
    private Controller controller;
    JCheckBox saveWindow;
    JCheckBox saveOverall;
    JTextArea windowSize;
    JTextArea windowOverlap;
    JTextArea definition;
    JTextArea value;

    public ViewBatchAction(Controller c) {
        super("View Batch");
        this.controller = c;
    }

    public void setFeatureFields(JCheckBox saveWindow, JCheckBox saveOverall, JTextArea windowSize, JTextArea windowOverlap) {
        this.saveWindow = saveWindow;
        this.saveOverall = saveOverall;
        this.windowSize = windowSize;
        this.windowOverlap = windowOverlap;
    }

    public void setRecordingFields(JTextArea definition, JTextArea value) {
        this.definition = definition;
        this.value = value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int count = 0;
        Component src = this.controller.viewBatch.getMenuComponent(count);
        String action = "";
        if (src instanceof JMenuItem) {
            action = ((JMenuItem)src).getActionCommand();
        }
        while (!e.getActionCommand().equals(action)) {
            if (!((src = this.controller.viewBatch.getMenuComponent(++count)) instanceof JMenuItem)) continue;
            action = ((JMenuItem)src).getActionCommand();
        }
        try {
            Batch batch = this.controller.batches.get(count);
            this.controller.dm_.aggregators = batch.getAggregator();
            RecordingInfo[][] recording = new RecordingInfo[1][];
            int[] windowSize = new int[1];
            double[] windowOverlap = new double[]{0.0};
            double[] samplingRate = new double[]{0.0};
            boolean[] normalise = new boolean[1];
            boolean[] perWindow = new boolean[1];
            boolean[] overall = new boolean[1];
            String[] destinationFK = new String[]{""};
            String[] destinationFV = new String[]{""};
            int[] outputType = new int[1];
            batch.applySettings(recording, windowSize, windowOverlap, samplingRate, normalise, perWindow, overall, destinationFK, destinationFV, outputType);
            this.controller.rtm_.clearTable();
            this.controller.rtm_.fillTable(recording[0]);
            this.controller.fstm_.clearTable();
            this.controller.fstm_.fillTable(this.controller.dm_.featureDefinitions, this.controller.dm_.defaults, this.controller.dm_.is_primary);
            this.windowSize.setText(Integer.toString(windowSize[0]));
            this.windowOverlap.setText(Double.toString(windowOverlap[0]));
            this.setSamplingRateBox(samplingRate[0]);
            this.controller.normalise.setSelected(normalise[0]);
            this.saveWindow.setSelected(perWindow[0]);
            this.saveOverall.setSelected(overall[0]);
            this.definition.setText(destinationFK[0]);
            this.value.setText(destinationFV[0]);
            if (outputType[0] == 0) {
                ((JRadioButtonMenuItem)this.controller.outputType.getMenuComponent(0)).setSelected(true);
                this.controller.outputTypeAction.setSelected(0);
            } else {
                ((JRadioButtonMenuItem)this.controller.outputType.getMenuComponent(1)).setSelected(true);
                this.controller.outputTypeAction.setSelected(1);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
            JOptionPane.showMessageDialog(null, e1.getMessage(), "ERROR", 0);
        }
    }

    private void setSamplingRateBox(double rate) {
        if (rate <= 8000.0) {
            ((JRadioButtonMenuItem)this.controller.sampleRate.getMenuComponent(0)).setSelected(true);
        } else if (rate <= 11025.0) {
            ((JRadioButtonMenuItem)this.controller.sampleRate.getMenuComponent(1)).setSelected(true);
        } else if (rate <= 16000.0) {
            ((JRadioButtonMenuItem)this.controller.sampleRate.getMenuComponent(2)).setSelected(true);
        } else if (rate <= 22050.0) {
            ((JRadioButtonMenuItem)this.controller.sampleRate.getMenuComponent(3)).setSelected(true);
        } else {
            ((JRadioButtonMenuItem)this.controller.sampleRate.getMenuComponent(4)).setSelected(true);
        }
    }
}

