/*
 * Decompiled with CFR 0.152.
 */
package jAudioFeatureExtractor.jAudioTools;

public class DSPMethods {
    public static double[][] applyGain(double[][] samples, double gain) {
        double[][] altered_samples = new double[samples.length][];
        int i = 0;
        while (i < altered_samples.length) {
            altered_samples[i] = new double[samples[i].length];
            int j = 0;
            while (j < altered_samples[i].length) {
                altered_samples[i][j] = samples[i][j] * gain;
                ++j;
            }
            ++i;
        }
        return altered_samples;
    }

    public static double[] getSamplesMixedDownIntoOneChannel(double[][] audio_samples) {
        if (audio_samples.length == 1) {
            return audio_samples[0];
        }
        double number_channels = audio_samples.length;
        int number_samples = audio_samples[0].length;
        double[] samples_mixed_down = new double[number_samples];
        int samp = 0;
        while (samp < number_samples) {
            double total_so_far = 0.0;
            int chan = 0;
            while ((double)chan < number_channels) {
                total_so_far += audio_samples[chan][samp];
                ++chan;
            }
            samples_mixed_down[samp] = total_so_far / number_channels;
            ++samp;
        }
        return samples_mixed_down;
    }

    public static double[] normalizeSamples(double[] samples_to_normalize) {
        double[] normalized_samples = new double[samples_to_normalize.length];
        int samp = 0;
        while (samp < normalized_samples.length) {
            normalized_samples[samp] = samples_to_normalize[samp];
            ++samp;
        }
        double max_sample_value = 0.0;
        int samp2 = 0;
        while (samp2 < normalized_samples.length) {
            if (Math.abs(normalized_samples[samp2]) > max_sample_value) {
                max_sample_value = Math.abs(normalized_samples[samp2]);
            }
            ++samp2;
        }
        if (max_sample_value != 0.0) {
            samp2 = 0;
            while (samp2 < normalized_samples.length) {
                int n = samp2++;
                normalized_samples[n] = normalized_samples[n] / max_sample_value;
            }
        }
        return normalized_samples;
    }

    public static double[][] normalizeSamples(double[][] samples_to_normalize) {
        int samp;
        double[][] normalized_samples = new double[samples_to_normalize.length][samples_to_normalize[0].length];
        int chan = 0;
        while (chan < normalized_samples.length) {
            int samp2 = 0;
            while (samp2 < normalized_samples[chan].length) {
                normalized_samples[chan][samp2] = samples_to_normalize[chan][samp2];
                ++samp2;
            }
            ++chan;
        }
        double max_sample_value = 0.0;
        int chan2 = 0;
        while (chan2 < normalized_samples.length) {
            samp = 0;
            while (samp < normalized_samples[chan2].length) {
                if (Math.abs(normalized_samples[chan2][samp]) > max_sample_value) {
                    max_sample_value = Math.abs(normalized_samples[chan2][samp]);
                }
                ++samp;
            }
            ++chan2;
        }
        if (max_sample_value != 0.0) {
            chan2 = 0;
            while (chan2 < normalized_samples.length) {
                samp = 0;
                while (samp < normalized_samples[chan2].length) {
                    double[] dArray = normalized_samples[chan2];
                    int n = samp++;
                    dArray[n] = dArray[n] / max_sample_value;
                }
                ++chan2;
            }
        }
        return normalized_samples;
    }

    public static double[][] getCopyOfSamples(double[][] original_samples) {
        double[][] new_samples = new double[original_samples.length][];
        int chan = 0;
        while (chan < new_samples.length) {
            new_samples[chan] = new double[original_samples[chan].length];
            int samp = 0;
            while (samp < new_samples[chan].length) {
                new_samples[chan][samp] = original_samples[chan][samp];
                ++samp;
            }
            ++chan;
        }
        return new_samples;
    }

    public static int convertTimeToSample(double time, float sampling_rate) {
        return (int)Math.round(time * (double)sampling_rate);
    }

    public static double convertSampleToTime(int sample, float sampling_rate) {
        return (double)sample / (double)sampling_rate;
    }

    public static double[] getAutoCorrelation(double[] signal, int min_lag, int max_lag) {
        double[] autocorrelation = new double[max_lag - min_lag + 1];
        int lag = min_lag;
        while (lag <= max_lag) {
            int auto_indice = lag - min_lag;
            autocorrelation[auto_indice] = 0.0;
            int samp = 0;
            while (samp < signal.length - lag) {
                int n = auto_indice;
                autocorrelation[n] = autocorrelation[n] + signal[samp] * signal[samp + lag];
                ++samp;
            }
            ++lag;
        }
        return autocorrelation;
    }

    public static double[] getAutoCorrelationLabels(double sampling_rate, int min_lag, int max_lag) {
        double[] labels = new double[max_lag - min_lag + 1];
        int i = 0;
        while (i < labels.length) {
            labels[i] = sampling_rate / (double)(i + min_lag);
            ++i;
        }
        return labels;
    }
}

