/*
 * Decompiled with CFR 0.152.
 */
package org.oc.ocvolume.dsp;

public class fft {
    protected static int numPoints;
    public static double[] real;
    public static double[] imag;

    public static void computeFFT(double[] signal) {
        numPoints = signal.length;
        real = new double[numPoints];
        imag = new double[numPoints];
        real = signal;
        int i = 0;
        while (i < imag.length) {
            fft.imag[i] = 0.0;
            ++i;
        }
        fft.FFT();
    }

    private static void FFT() {
        int halfNumPoints;
        if (numPoints == 1) {
            return;
        }
        double pi = Math.PI;
        int numStages = (int)(Math.log(numPoints) / Math.log(2.0));
        int j = halfNumPoints = numPoints >> 1;
        int k = 0;
        int i = 1;
        while (i < numPoints - 2) {
            if (i < j) {
                double tempReal = real[j];
                double tempImag = imag[j];
                fft.real[j] = real[i];
                fft.imag[j] = imag[i];
                fft.real[i] = tempReal;
                fft.imag[i] = tempImag;
            }
            k = halfNumPoints;
            while (k <= j) {
                j -= k;
                k >>= 1;
            }
            j += k;
            ++i;
        }
        int stage = 1;
        while (stage <= numStages) {
            int LE = 1;
            int i2 = 0;
            while (i2 < stage) {
                LE <<= 1;
                ++i2;
            }
            int LE2 = LE >> 1;
            double UR = 1.0;
            double UI = 0.0;
            double SR = Math.cos(Math.PI / (double)LE2);
            double SI = -Math.sin(Math.PI / (double)LE2);
            int subDFT = 1;
            while (subDFT <= LE2) {
                int butterfly = subDFT - 1;
                while (butterfly <= numPoints - 1) {
                    int ip = butterfly + LE2;
                    double tempReal = real[ip] * UR - imag[ip] * UI;
                    double tempImag = real[ip] * UI + imag[ip] * UR;
                    fft.real[ip] = real[butterfly] - tempReal;
                    fft.imag[ip] = imag[butterfly] - tempImag;
                    int n = butterfly;
                    real[n] = real[n] + tempReal;
                    int n2 = butterfly;
                    imag[n2] = imag[n2] + tempImag;
                    butterfly += LE;
                }
                double tempUR = UR;
                UR = tempUR * SR - UI * SI;
                UI = tempUR * SI + UI * SR;
                ++subDFT;
            }
            ++stage;
        }
    }
}

