/*
 * Decompiled with CFR 0.152.
 */
package ml.dmlc.xgboost4j.java;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class NativeLibLoader {
    private static final Log logger = LogFactory.getLog(NativeLibLoader.class);
    private static boolean initialized = false;
    private static final String nativeResourcePath = "/lib";
    private static final String[] libNames = new String[]{"xgboost4j"};

    NativeLibLoader() {
    }

    static synchronized void initXGBoost() throws IOException {
        if (!initialized) {
            String platform = NativeLibLoader.computePlatformArchitecture();
            for (String libName : libNames) {
                try {
                    String libraryPathInJar = "/lib/" + platform + "/" + System.mapLibraryName(libName);
                    NativeLibLoader.loadLibraryFromJar(libraryPathInJar);
                }
                catch (IOException ioe) {
                    logger.error((Object)("failed to load " + libName + " library from jar for platform " + platform));
                    throw ioe;
                }
            }
            initialized = true;
        }
    }

    private static String computePlatformArchitecture() {
        String detectedArch;
        String detectedOS;
        String os = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
        if (os.contains("mac") || os.contains("darwin")) {
            detectedOS = "macos";
        } else if (os.contains("win")) {
            detectedOS = "windows";
        } else if (os.contains("nux")) {
            detectedOS = "linux";
        } else if (os.contains("sunos")) {
            detectedOS = "solaris";
        } else {
            throw new IllegalStateException("Unsupported os:" + os);
        }
        String arch = System.getProperty("os.arch", "generic").toLowerCase(Locale.ENGLISH);
        if (arch.startsWith("amd64") || arch.startsWith("x86_64")) {
            detectedArch = "x86_64";
        } else if (arch.startsWith("aarch64") || arch.startsWith("arm64")) {
            detectedArch = "aarch64";
        } else if (arch.startsWith("sparc")) {
            detectedArch = "sparc";
        } else {
            throw new IllegalStateException("Unsupported architecture:" + arch);
        }
        return detectedOS + "/" + detectedArch;
    }

    private static void loadLibraryFromJar(String path) throws IOException, IllegalArgumentException {
        String temp = NativeLibLoader.createTempFileFromResource(path);
        System.load(temp);
    }

    static String createTempFileFromResource(String path) throws IOException, IllegalArgumentException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("The path has to be absolute (start with '/').");
        }
        String[] parts = path.split("/");
        String filename = parts.length > 1 ? parts[parts.length - 1] : null;
        String prefix = "";
        String suffix = null;
        if (filename != null) {
            parts = filename.split("\\.", 2);
            prefix = parts[0];
            String string = suffix = parts.length > 1 ? "." + parts[parts.length - 1] : null;
        }
        if (filename == null || prefix.length() < 3) {
            throw new IllegalArgumentException("The filename has to be at least 3 characters long.");
        }
        File temp = File.createTempFile(prefix, suffix);
        temp.deleteOnExit();
        if (!temp.exists()) {
            throw new FileNotFoundException("File " + temp.getAbsolutePath() + " does not exist.");
        }
        byte[] buffer = new byte[1024];
        try (InputStream is = NativeLibLoader.class.getResourceAsStream(path);
             FileOutputStream os = new FileOutputStream(temp);){
            int readBytes;
            if (is == null) {
                throw new FileNotFoundException("File " + path + " was not found inside JAR.");
            }
            while ((readBytes = is.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, readBytes);
            }
        }
        return temp.getAbsolutePath();
    }
}

