/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.bus;

import java.util.Collection;
import net.engio.mbassy.bus.BusRuntime;
import net.engio.mbassy.common.DeadMessage;
import net.engio.mbassy.common.FilteredMessage;
import net.engio.mbassy.subscription.Subscription;

public class MessagePublication {
    private final Collection<Subscription> subscriptions;
    private final Object message;
    private volatile State state = State.Initial;
    private volatile boolean delivered = false;
    private final BusRuntime runtime;

    protected MessagePublication(BusRuntime runtime, Collection<Subscription> subscriptions, Object message, State initialState) {
        this.runtime = runtime;
        this.subscriptions = subscriptions;
        this.message = message;
        this.state = initialState;
    }

    public boolean add(Subscription subscription) {
        return this.subscriptions.add(subscription);
    }

    protected void execute() {
        this.state = State.Running;
        for (Subscription sub : this.subscriptions) {
            sub.publish(this, this.message);
        }
        this.state = State.Finished;
        if (!this.delivered) {
            if (!this.isFilteredEvent() && !this.isDeadEvent()) {
                this.runtime.getProvider().publish(new FilteredMessage(this.message));
            } else if (!this.isDeadEvent()) {
                this.runtime.getProvider().publish(new DeadMessage(this.message));
            }
        }
    }

    public boolean isFinished() {
        return this.state.equals((Object)State.Finished);
    }

    public boolean isRunning() {
        return this.state.equals((Object)State.Running);
    }

    public boolean isScheduled() {
        return this.state.equals((Object)State.Scheduled);
    }

    public void markDelivered() {
        this.delivered = true;
    }

    public MessagePublication markScheduled() {
        if (this.state.equals((Object)State.Initial)) {
            this.state = State.Scheduled;
        }
        return this;
    }

    public boolean isDeadEvent() {
        return DeadMessage.class.isAssignableFrom(this.message.getClass());
    }

    public boolean isFilteredEvent() {
        return FilteredMessage.class.isAssignableFrom(this.message.getClass());
    }

    public static class Factory {
        public MessagePublication createPublication(BusRuntime runtime, Collection<Subscription> subscriptions, Object message) {
            return new MessagePublication(runtime, subscriptions, message, State.Initial);
        }
    }

    private static enum State {
        Initial,
        Scheduled,
        Running,
        Finished,
        Error;

    }
}

