/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.subscription;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.engio.mbassy.bus.BusRuntime;
import net.engio.mbassy.common.ReflectionUtils;
import net.engio.mbassy.common.StrongConcurrentSet;
import net.engio.mbassy.listener.MessageHandlerMetadata;
import net.engio.mbassy.listener.MetadataReader;
import net.engio.mbassy.subscription.Subscription;
import net.engio.mbassy.subscription.SubscriptionFactory;

public class SubscriptionManager {
    private final MetadataReader metadataReader;
    private final Map<Class, Collection<Subscription>> subscriptionsPerMessage = new HashMap<Class, Collection<Subscription>>(50);
    private final Map<Class, Collection<Subscription>> subscriptionsPerListener = new HashMap<Class, Collection<Subscription>>(50);
    private final StrongConcurrentSet<Class> nonListeners = new StrongConcurrentSet();
    private final SubscriptionFactory subscriptionFactory;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final BusRuntime runtime;

    public SubscriptionManager(MetadataReader metadataReader, SubscriptionFactory subscriptionFactory, BusRuntime runtime) {
        this.metadataReader = metadataReader;
        this.subscriptionFactory = subscriptionFactory;
        this.runtime = runtime;
    }

    public boolean unsubscribe(Object listener) {
        if (listener == null) {
            return false;
        }
        Collection<Subscription> subscriptions = this.getSubscriptionsByListener(listener);
        if (subscriptions == null) {
            return false;
        }
        boolean isRemoved = true;
        for (Subscription subscription : subscriptions) {
            isRemoved &= subscription.unsubscribe(listener);
        }
        return isRemoved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Subscription> getSubscriptionsByListener(Object listener) {
        Collection<Subscription> subscriptions;
        try {
            this.readWriteLock.readLock().lock();
            subscriptions = this.subscriptionsPerListener.get(listener.getClass());
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return subscriptions;
    }

    public void subscribe(Object listener) {
        try {
            if (this.isKnownNonListener(listener)) {
                return;
            }
            Collection<Subscription> subscriptionsByListener = this.getSubscriptionsByListener(listener);
            if (subscriptionsByListener == null) {
                List<MessageHandlerMetadata> messageHandlers = this.metadataReader.getMessageListener(listener.getClass()).getHandlers();
                if (messageHandlers.isEmpty()) {
                    this.nonListeners.add(listener.getClass());
                    return;
                }
                subscriptionsByListener = new ArrayList<Subscription>(messageHandlers.size());
                for (MessageHandlerMetadata messageHandler : messageHandlers) {
                    subscriptionsByListener.add(this.subscriptionFactory.createSubscription(this.runtime, messageHandler));
                }
                this.subscribe(listener, subscriptionsByListener);
            } else {
                for (Subscription sub : subscriptionsByListener) {
                    sub.subscribe(listener);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe(Object listener, Collection<Subscription> subscriptions) {
        try {
            this.readWriteLock.writeLock().lock();
            Collection<Subscription> subscriptionsByListener = this.getSubscriptionsByListener(listener);
            if (subscriptionsByListener == null) {
                for (Subscription subscription : subscriptions) {
                    subscription.subscribe(listener);
                    for (Class<?> messageType : subscription.getHandledMessageTypes()) {
                        this.addMessageTypeSubscription(messageType, subscription);
                    }
                }
                this.subscriptionsPerListener.put(listener.getClass(), subscriptions);
            } else {
                for (Subscription existingSubscription : subscriptionsByListener) {
                    existingSubscription.subscribe(listener);
                }
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private boolean isKnownNonListener(Object listener) {
        Class<?> listeningClass = listener.getClass();
        return this.nonListeners.contains(listeningClass);
    }

    public Collection<Subscription> getSubscriptionsByMessageType(Class messageType) {
        TreeSet<Subscription> subscriptions = new TreeSet<Subscription>(Subscription.SubscriptionByPriorityDesc);
        this.readWriteLock.readLock().lock();
        if (this.subscriptionsPerMessage.get(messageType) != null) {
            subscriptions.addAll(this.subscriptionsPerMessage.get(messageType));
        }
        for (Class eventSuperType : ReflectionUtils.getSuperclasses(messageType)) {
            Collection<Subscription> subs = this.subscriptionsPerMessage.get(eventSuperType);
            if (subs == null) continue;
            for (Subscription sub : subs) {
                if (!sub.handlesMessageType(messageType)) continue;
                subscriptions.add(sub);
            }
        }
        this.readWriteLock.readLock().unlock();
        return subscriptions;
    }

    private void addMessageTypeSubscription(Class messageType, Subscription subscription) {
        Collection<Subscription> subscriptions = this.subscriptionsPerMessage.get(messageType);
        if (subscriptions == null) {
            subscriptions = new LinkedList<Subscription>();
            this.subscriptionsPerMessage.put(messageType, subscriptions);
        }
        subscriptions.add(subscription);
    }
}

