/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.generator;

import com.sun.msv.driver.textui.DebugController;
import com.sun.msv.generator.DOM2toSAX2;
import com.sun.msv.generator.DOMDecorator;
import com.sun.msv.generator.DataTypeGenerator;
import com.sun.msv.generator.DataTypeGeneratorImpl;
import com.sun.msv.generator.ExampleReader;
import com.sun.msv.generator.Generator;
import com.sun.msv.generator.GeneratorOption;
import com.sun.msv.generator.NoneTypeRemover;
import com.sun.msv.generator.Rand;
import com.sun.msv.generator.SchemaLocationRemover;
import com.sun.msv.grammar.ElementExp;
import com.sun.msv.grammar.Expression;
import com.sun.msv.grammar.ExpressionPool;
import com.sun.msv.grammar.ExpressionVisitorExpression;
import com.sun.msv.grammar.Grammar;
import com.sun.msv.grammar.relax.RELAXModule;
import com.sun.msv.grammar.util.RefExpRemover;
import com.sun.msv.grammar.xmlschema.XMLSchemaGrammar;
import com.sun.msv.reader.GrammarReaderController;
import com.sun.msv.reader.dtd.DTDReader;
import com.sun.msv.reader.util.GrammarLoader;
import com.sun.msv.relaxns.grammar.RELAXGrammar;
import com.sun.msv.util.StringPair;
import com.sun.msv.verifier.DocumentDeclaration;
import com.sun.msv.verifier.Verifier;
import com.sun.msv.verifier.regexp.ElementsOfConcernCollector;
import com.sun.msv.verifier.regexp.REDocumentDeclaration;
import com.sun.msv.verifier.util.ErrorHandlerImpl;
import com.sun.msv.verifier.util.IgnoreErrorHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Driver {
    public Grammar grammar;
    public String outputName = null;
    private String encoding = "UTF-8";
    private boolean createError = false;
    private boolean validate = true;
    private boolean debug = false;
    private boolean quiet = false;
    private boolean warning = false;
    private GeneratorOption opt = new GeneratorOption();
    private int number;
    private StringPair rootName;
    private SAXParserFactory factory;
    private DocumentBuilderFactory domFactory;
    public final Set exampleTokens;
    private DataTypeGeneratorImpl dtgi;

    public Driver() {
        this.opt.random = new Random();
        this.number = 1;
        this.rootName = null;
        this.factory = SAXParserFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(false);
        try {
            this.factory.setFeature("http://xml.org/sax/features/validation", false);
            this.factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.domFactory = DocumentBuilderFactory.newInstance();
        this.domFactory.setNamespaceAware(true);
        this.domFactory.setValidating(false);
        this.exampleTokens = new HashSet();
        this.dtgi = new DataTypeGeneratorImpl();
        this.opt.dtGenerator = this.dtgi;
        this.dtgi.tokens = this.exampleTokens;
    }

    private static void usage() {
        System.err.println("Sun XMLGenerator\n----------------\nUsage: XMLGenerator <options> <schema> [<output name>]\nOptions:\n  -dtd      : use a DTD as a schema\n  -ascii    : use US-ASCII characters only\n  -seed <n> : set random seed\n  -depth <n>: set cut back depth\n  -width <n>: maximum number of times '*'/'+' are repeated\n  -n <n>    : # of files to be generated\n  -warning  : show warnings.\n  -quiet    : be quiet.\n  -root {<namespaceURI>}<localName>\n      fix the root element to the given element\n  -encoding <str>\n      output encoding (Java name)\n  -example <filename>\n      use the given file as an example. tokens found in the example\n      is used to generate documents\n  -error <n>/<m>\n      error ratio. generate n errors per m elemnts (average).\n      to control error generation, see manual for details.\n  -nocomment: suppress insertion of comments that indicate generated errors.\n\n  <output name> must include one '$'. '$' will be replaced by number.\n  e.g., test.$.xml -> test.1.xml test.2.xml test.3.xml ...\n  if omitted, generated file will be sent to stdout.\n");
    }

    public static void main(String[] args) throws Exception {
        try {
            Driver driver = new Driver();
            try {
                driver.parseArguments(args);
            }
            catch (CommandLineException e) {
                System.err.println(e.getMessage());
                Driver.usage();
                System.exit(-1);
            }
            System.exit(driver.run(System.err));
        }
        catch (DataTypeGenerator.GenerationException e) {
            System.err.println(e.getMessage());
        }
    }

    protected double getRatio(String s) {
        double m;
        int idx = s.indexOf(47);
        double n = Double.parseDouble(s.substring(0, idx));
        double ratio = n / (m = Double.parseDouble(s.substring(idx + 1)));
        if (ratio <= 0.0 || ratio > 1.0) {
            System.err.println("error ratio out of range");
            Driver.usage();
            System.exit(-1);
        }
        return ratio;
    }

    public void parseArguments(String[] args) throws CommandLineException, ParserConfigurationException {
        String grammarName = null;
        boolean dtdAsSchema = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-debug")) {
                this.debug = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-dtd")) {
                dtdAsSchema = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-quiet")) {
                this.quiet = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-warning")) {
                this.warning = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-ascii")) {
                ((DataTypeGeneratorImpl)this.opt.dtGenerator).asciiOnly = true;
                continue;
            }
            if (args[i].equalsIgnoreCase("-nocomment")) {
                this.opt.insertComment = false;
                continue;
            }
            if (args[i].equalsIgnoreCase("-depth")) {
                this.opt.cutBackDepth = new Integer(args[++i]);
                continue;
            }
            if (args[i].equalsIgnoreCase("-example")) {
                String fileName = args[++i];
                try {
                    XMLReader p = this.factory.newSAXParser().getXMLReader();
                    p.setContentHandler(new ExampleReader(this.exampleTokens));
                    p.parse(Driver.getInputSource(fileName));
                    continue;
                }
                catch (IOException e) {
                    throw new CommandLineException("unable to parse " + fileName + " :" + e.getMessage());
                }
                catch (SAXException e) {
                    throw new CommandLineException("unable to parse " + fileName + " :" + e.getMessage());
                }
            }
            if (args[i].equalsIgnoreCase("-width")) {
                this.opt.width = new Rand.UniformRand(this.opt.random, new Integer(args[++i]));
                continue;
            }
            if (args[i].equalsIgnoreCase("-n")) {
                this.number = new Integer(args[++i]);
                if (this.number >= 1) continue;
                this.number = 1;
                continue;
            }
            if (args[i].equals("-root")) {
                String root;
                int idx;
                if ((idx = (root = args[++i]).indexOf(125)) < 0) {
                    this.rootName = new StringPair("", root);
                    continue;
                }
                this.rootName = new StringPair(root.substring(1, idx), root.substring(idx + 1));
                continue;
            }
            if (args[i].equalsIgnoreCase("-encoding")) {
                this.encoding = args[++i];
                continue;
            }
            if (args[i].equalsIgnoreCase("-seed")) {
                this.opt.random.setSeed(new Long(args[++i]));
                continue;
            }
            if (args[i].equalsIgnoreCase("-nonvalidate")) {
                this.validate = false;
                continue;
            }
            if (args[i].startsWith("-error")) {
                this.createError = true;
                if (args[i].equalsIgnoreCase("-error")) {
                    this.opt.probAttrNameTypo = this.opt.probElemNameTypo = this.getRatio(args[++i]);
                    this.opt.probMissingPlus = this.opt.probElemNameTypo;
                    this.opt.probSlipInElemError = this.opt.probElemNameTypo;
                    this.opt.probSlipInAttrError = this.opt.probElemNameTypo;
                    this.opt.probSeqError = this.opt.probElemNameTypo;
                    this.opt.probMutatedElemError = this.opt.probElemNameTypo;
                    this.opt.probMutatedAttrError = this.opt.probElemNameTypo;
                    this.opt.probMissingElemError = this.opt.probElemNameTypo;
                    this.opt.probMissingAttrError = this.opt.probElemNameTypo;
                    this.opt.probGreedyChoiceError = this.opt.probElemNameTypo;
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-greedyChoice")) {
                    this.opt.probGreedyChoiceError = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-missingAttribute")) {
                    this.opt.probMissingAttrError = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-missingElement")) {
                    this.opt.probMissingElemError = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-mutatedAttribute")) {
                    this.opt.probMutatedAttrError = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-mutatedElement")) {
                    this.opt.probMutatedElemError = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-sequenceError")) {
                    this.opt.probSeqError = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-slipInAttribute")) {
                    this.opt.probSlipInAttrError = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-slipInElement")) {
                    this.opt.probSlipInElemError = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-missingPlus")) {
                    this.opt.probMissingPlus = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-attributeNameTypo")) {
                    this.opt.probAttrNameTypo = this.getRatio(args[++i]);
                    continue;
                }
                if (args[i].equalsIgnoreCase("-error-attributeNameTypo")) {
                    this.opt.probElemNameTypo = this.getRatio(args[++i]);
                    continue;
                }
                throw new CommandLineException("unrecognized option :" + args[i]);
            }
            if (args[i].charAt(0) == '-') {
                throw new CommandLineException("unrecognized option :" + args[i]);
            }
            if (grammarName == null) {
                grammarName = args[i];
                continue;
            }
            if (this.outputName == null) {
                this.outputName = args[i];
                continue;
            }
            throw new CommandLineException("too many parameters");
        }
        if (grammarName != null) {
            if (!this.quiet) {
                System.err.println("parsing a grammar: " + grammarName);
            }
            InputSource is = Driver.getInputSource(grammarName);
            try {
                this.grammar = dtdAsSchema ? DTDReader.parse((InputSource)is, (GrammarReaderController)new DebugController(this.warning, this.quiet), (ExpressionPool)new ExpressionPool()) : GrammarLoader.loadSchema((InputSource)is, (GrammarReaderController)new DebugController(this.warning, this.quiet), (SAXParserFactory)this.factory);
            }
            catch (IOException e) {
                throw new CommandLineException("unable to parse " + grammarName + " :" + e.getMessage());
            }
            catch (SAXException e) {
                throw new CommandLineException("unable to parse " + grammarName + " :" + e.getMessage());
            }
        }
    }

    public int run(PrintStream out) throws Exception {
        if (this.grammar == null) {
            Driver.usage();
            return -1;
        }
        Expression topLevel = this.grammar.getTopLevel();
        if (this.grammar instanceof RELAXGrammar || this.grammar instanceof RELAXModule) {
            topLevel = topLevel.visit((ExpressionVisitorExpression)new NoneTypeRemover(this.grammar.getPool()));
        }
        if (this.grammar instanceof XMLSchemaGrammar) {
            topLevel = topLevel.visit((ExpressionVisitorExpression)new SchemaLocationRemover(this.grammar.getPool()));
        }
        topLevel = topLevel.visit((ExpressionVisitorExpression)new RefExpRemover(this.grammar.getPool(), true));
        if (this.rootName != null && (topLevel = this.findElement(topLevel, this.rootName)) == null) {
            out.println("unable to find the specified root element: " + this.rootName);
            return -1;
        }
        this.opt.pool = this.grammar.getPool();
        for (int i = 0; i < this.number; ++i) {
            OutputStream os;
            Document dom;
            block14: {
                if (!this.quiet) {
                    if (this.number <= 10) {
                        out.println("generating document #" + (i + 1));
                    } else {
                        out.print(">");
                    }
                }
                int retry = 0;
                do {
                    dom = this.domFactory.newDocumentBuilder().newDocument();
                    Generator.generate(topLevel, dom, this.opt);
                    if (!this.validate) break block14;
                    DOM2toSAX2 d2s = new DOM2toSAX2();
                    Verifier v = new Verifier((DocumentDeclaration)new REDocumentDeclaration(this.grammar), (ErrorHandler)(this.debug ? new ErrorHandlerImpl() : new IgnoreErrorHandler()));
                    d2s.setContentHandler((ContentHandler)v);
                    d2s.traverse(dom);
                    if (this.createError && !v.isValid() || !this.createError && v.isValid()) break block14;
                } while (retry++ != 100);
                out.println("unable to generate a proper instance.");
                return -1;
            }
            if (this.outputName == null) {
                os = System.out;
            } else {
                int idx = this.outputName.indexOf(36);
                if (idx != -1) {
                    String s = Integer.toString(i);
                    for (int j = s.length(); j < Integer.toString(this.number - 1).length(); ++j) {
                        s = "0" + s;
                    }
                    os = new FileOutputStream(this.outputName.substring(0, idx) + s + this.outputName.substring(idx + 1));
                } else {
                    os = new FileOutputStream(this.outputName);
                }
            }
            DOMDecorator.decorate(dom);
            XMLSerializer s = new XMLSerializer(os, new OutputFormat("XML", this.encoding, true));
            s.serialize(dom);
            if (os == System.out) continue;
            os.close();
        }
        out.println();
        return 0;
    }

    private Expression findElement(Expression exp, StringPair name) {
        Vector vec = new Vector();
        new ElementsOfConcernCollector().collect(exp, vec);
        for (int i = 0; i < vec.size(); ++i) {
            ElementExp eexp = (ElementExp)vec.get(i);
            if (!eexp.getNameClass().accepts(name)) continue;
            return eexp;
        }
        return null;
    }

    private static InputSource getInputSource(String fileOrURL) {
        try {
            String path = new File(fileOrURL).getAbsolutePath();
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            return new InputSource(new URL("file", "", path).toExternalForm());
        }
        catch (Exception e) {
            return new InputSource(fileOrURL);
        }
    }

    private static class CommandLineException
    extends Exception {
        public CommandLineException(String msg) {
            super(msg);
        }
    }
}

