/*
 * Decompiled with CFR 0.152.
 */
package net.lightbody.bmp.mitm;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import net.lightbody.bmp.mitm.CertificateAndKey;
import net.lightbody.bmp.mitm.CertificateAndKeySource;
import net.lightbody.bmp.mitm.KeyStoreCertificateSource;
import net.lightbody.bmp.mitm.exception.CertificateSourceException;
import net.lightbody.bmp.mitm.tools.DefaultSecurityProviderTool;
import net.lightbody.bmp.mitm.tools.SecurityProviderTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreFileCertificateSource
implements CertificateAndKeySource {
    private static final Logger log = LoggerFactory.getLogger(KeyStoreFileCertificateSource.class);
    private final String keyStoreClasspathResource;
    private final File keyStoreFile;
    private final String keyStoreType;
    private final String keyStorePassword;
    private final String privateKeyAlias;
    private SecurityProviderTool securityProviderTool = new DefaultSecurityProviderTool();
    private final Supplier<CertificateAndKey> certificateAndKey = Suppliers.memoize((Supplier)new Supplier<CertificateAndKey>(){

        public CertificateAndKey get() {
            return KeyStoreFileCertificateSource.this.loadKeyStore();
        }
    });

    public KeyStoreFileCertificateSource(String keyStoreType, String keyStoreClasspathResource, String privateKeyAlias, String keyStorePassword) {
        if (keyStoreClasspathResource == null) {
            throw new IllegalArgumentException("The classpath location of the KeyStore cannot be null");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("KeyStore type cannot be null");
        }
        if (privateKeyAlias == null) {
            throw new IllegalArgumentException("Alias of the private key in the KeyStore cannot be null");
        }
        this.keyStoreClasspathResource = keyStoreClasspathResource;
        this.keyStoreFile = null;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.privateKeyAlias = privateKeyAlias;
    }

    public KeyStoreFileCertificateSource(String keyStoreType, File keyStoreFile, String privateKeyAlias, String keyStorePassword) {
        if (keyStoreFile == null) {
            throw new IllegalArgumentException("The KeyStore file cannot be null");
        }
        if (keyStoreType == null) {
            throw new IllegalArgumentException("KeyStore type cannot be null");
        }
        if (privateKeyAlias == null) {
            throw new IllegalArgumentException("Alias of the private key in the KeyStore cannot be null");
        }
        this.keyStoreFile = keyStoreFile;
        this.keyStoreClasspathResource = null;
        this.keyStoreType = keyStoreType;
        this.keyStorePassword = keyStorePassword;
        this.privateKeyAlias = privateKeyAlias;
    }

    public KeyStoreFileCertificateSource certificateTool(SecurityProviderTool securityProviderTool) {
        this.securityProviderTool = securityProviderTool;
        return this;
    }

    @Override
    public CertificateAndKey load() {
        return (CertificateAndKey)this.certificateAndKey.get();
    }

    private CertificateAndKey loadKeyStore() {
        KeyStore keyStore;
        if (this.keyStoreFile != null) {
            keyStore = this.securityProviderTool.loadKeyStore(this.keyStoreFile, this.keyStoreType, this.keyStorePassword);
        } else {
            Path tempKeyStoreFile = null;
            try {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream keystoreAsStream = KeyStoreFileCertificateSource.class.getResourceAsStream(this.keyStoreClasspathResource);){
                        tempKeyStoreFile = Files.createTempFile("keystore", "temp", new FileAttribute[0]);
                        Files.copy(keystoreAsStream, tempKeyStoreFile, StandardCopyOption.REPLACE_EXISTING);
                        keyStore = this.securityProviderTool.loadKeyStore(tempKeyStoreFile.toFile(), this.keyStoreType, this.keyStorePassword);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new CertificateSourceException("Unable to open KeyStore classpath resource: " + this.keyStoreClasspathResource, e);
                }
            }
            catch (Throwable throwable) {
                if (tempKeyStoreFile != null) {
                    try {
                        Files.deleteIfExists(tempKeyStoreFile);
                    }
                    catch (IOException iOException) {
                        log.warn("Unable to delete temporary KeyStore file: {}.", (Object)tempKeyStoreFile.toAbsolutePath());
                    }
                }
                throw throwable;
            }
            if (tempKeyStoreFile != null) {
                try {
                    Files.deleteIfExists(tempKeyStoreFile);
                }
                catch (IOException iOException) {
                    log.warn("Unable to delete temporary KeyStore file: {}.", (Object)tempKeyStoreFile.toAbsolutePath());
                }
            }
        }
        KeyStoreCertificateSource keyStoreCertificateSource = new KeyStoreCertificateSource(keyStore, this.privateKeyAlias, this.keyStorePassword);
        return keyStoreCertificateSource.load();
    }
}

