/*
 * Decompiled with CFR 0.152.
 */
package odk.lang;

public strictfp final class NumbersUtils {
    private static final int MIN_DOUBLE_EXPONENT = -1074;
    private static final int MAX_DOUBLE_EXPONENT = 1023;

    public static boolean isInRange(int min, int max, int a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(long min, long max, long a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(float min, float max, float a) {
        return min <= a && a <= max;
    }

    public static boolean isInRange(double min, double max, double a) {
        return min <= a && a <= max;
    }

    public static boolean checkIsInRange(int min, int max, int a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(long min, long max, long a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(float min, float max, float a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean checkIsInRange(double min, double max, double a) {
        if (!NumbersUtils.isInRange(min, max, a)) {
            throw new IllegalArgumentException(String.valueOf(a) + " not in [" + min + "," + max + "]");
        }
        return true;
    }

    public static boolean isInRangeSigned(int a, int bitSize) {
        return NumbersUtils.minSignedIntForBitSize(bitSize) <= a && a <= NumbersUtils.maxSignedIntForBitSize(bitSize);
    }

    public static boolean isInRangeSigned(long a, int bitSize) {
        return NumbersUtils.minSignedLongForBitSize(bitSize) <= a && a <= NumbersUtils.maxSignedLongForBitSize(bitSize);
    }

    public static boolean isInRangeUnsigned(int a, int bitSize) {
        return a >= 0 && a <= NumbersUtils.maxUnsignedIntForBitSize(bitSize);
    }

    public static boolean isInRangeUnsigned(long a, int bitSize) {
        return 0L <= a && a <= NumbersUtils.maxUnsignedLongForBitSize(bitSize);
    }

    public static boolean checkIsInRangeSigned(int a, int bitSize) {
        if (!NumbersUtils.isInRangeSigned(a, bitSize)) {
            throw new IllegalArgumentException(String.valueOf(a) + " does not fit as signed value on " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeSigned(long a, int bitSize) {
        if (!NumbersUtils.isInRangeSigned(a, bitSize)) {
            throw new IllegalArgumentException(String.valueOf(a) + " does not fit as signed value on " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeUnsigned(int a, int bitSize) {
        if (!NumbersUtils.isInRangeUnsigned(a, bitSize)) {
            throw new IllegalArgumentException(String.valueOf(a) + " does not fit as unsigned value on " + bitSize + " bits");
        }
        return true;
    }

    public static boolean checkIsInRangeUnsigned(long a, int bitSize) {
        if (!NumbersUtils.isInRangeUnsigned(a, bitSize)) {
            throw new IllegalArgumentException(String.valueOf(a) + " does not fit as unsigned value on " + bitSize + " bits");
        }
        return true;
    }

    public static int leftBit0IntMask(int nbrOfBits) {
        assert (NumbersUtils.checkIsInRange(0, 32, nbrOfBits));
        if (nbrOfBits == 32) {
            return 0;
        }
        return -1 >>> nbrOfBits;
    }

    public static int leftBit1IntMask(int nbrOfBits) {
        return ~NumbersUtils.leftBit0IntMask(nbrOfBits);
    }

    public static int rightBit0IntMask(int nbrOfBits) {
        return ~NumbersUtils.leftBit0IntMask(32 - nbrOfBits);
    }

    public static int rightBit1IntMask(int nbrOfBits) {
        return NumbersUtils.leftBit0IntMask(32 - nbrOfBits);
    }

    public static long leftBit0LongMask(int nbrOfBits) {
        assert (NumbersUtils.checkIsInRange(0, 64, nbrOfBits));
        if (nbrOfBits == 64) {
            return 0L;
        }
        return -1L >>> nbrOfBits;
    }

    public static long leftBit1LongMask(int nbrOfBits) {
        return NumbersUtils.leftBit0LongMask(nbrOfBits) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long rightBit0LongMask(int nbrOfBits) {
        return NumbersUtils.leftBit0LongMask(64 - nbrOfBits) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public static long rightBit1LongMask(int nbrOfBits) {
        return NumbersUtils.leftBit0LongMask(64 - nbrOfBits);
    }

    public static boolean isValidBitSizeForSignedInt(int bitSize) {
        return bitSize >= 1 && bitSize <= 32;
    }

    public static boolean isValidBitSizeForSignedLong(int bitSize) {
        return bitSize >= 1 && bitSize <= 64;
    }

    public static boolean isValidBitSizeForUnsignedInt(int bitSize) {
        return bitSize >= 1 && bitSize <= 31;
    }

    public static boolean isValidBitSizeForUnsignedLong(int bitSize) {
        return bitSize >= 1 && bitSize <= 63;
    }

    public static boolean checkBitSizeForSignedInt(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForSignedInt(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,32] for signed int values");
        }
        return true;
    }

    public static boolean checkBitSizeForSignedLong(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForSignedLong(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,64] for signed long values");
        }
        return true;
    }

    public static boolean checkBitSizeForUnsignedInt(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForUnsignedInt(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,31] for unsigned int values");
        }
        return true;
    }

    public static boolean checkBitSizeForUnsignedLong(int bitSize) {
        if (!NumbersUtils.isValidBitSizeForUnsignedLong(bitSize)) {
            throw new IllegalArgumentException("bit size [" + bitSize + "] must be in [1,63] for unsigned long values");
        }
        return true;
    }

    public static int minSignedIntForBitSize(int bitSize) {
        assert (NumbersUtils.checkBitSizeForSignedInt(bitSize));
        return Integer.MIN_VALUE >> 32 - bitSize;
    }

    public static int maxSignedIntForBitSize(int bitSize) {
        assert (NumbersUtils.checkBitSizeForSignedInt(bitSize));
        return Integer.MAX_VALUE >> 32 - bitSize;
    }

    public static long minSignedLongForBitSize(int bitSize) {
        assert (NumbersUtils.checkBitSizeForSignedLong(bitSize));
        return Long.MIN_VALUE >> 64 - bitSize;
    }

    public static long maxSignedLongForBitSize(int bitSize) {
        assert (NumbersUtils.checkBitSizeForSignedLong(bitSize));
        return Long.MAX_VALUE >> 64 - bitSize;
    }

    public static int maxUnsignedIntForBitSize(int bitSize) {
        assert (NumbersUtils.checkBitSizeForUnsignedLong(bitSize));
        return Integer.MAX_VALUE >> 31 - bitSize;
    }

    public static long maxUnsignedLongForBitSize(int bitSize) {
        assert (NumbersUtils.checkBitSizeForUnsignedLong(bitSize));
        return Long.MAX_VALUE >> 63 - bitSize;
    }

    public static int bitSizeForSignedValue(int value) {
        if (value > 0) {
            return 33 - Integer.numberOfLeadingZeros(value);
        }
        if (value == 0) {
            return 1;
        }
        return 33 - Integer.numberOfLeadingZeros(-value - 1);
    }

    public static int bitSizeForSignedValue(long value) {
        if (value > 0L) {
            return 65 - Long.numberOfLeadingZeros(value);
        }
        if (value == 0L) {
            return 1;
        }
        return 65 - Long.numberOfLeadingZeros(-value - 1L);
    }

    public static int bitSizeForUnsignedValue(int value) {
        if (value > 0) {
            return 32 - Integer.numberOfLeadingZeros(value);
        }
        if (value == 0) {
            return 1;
        }
        throw new IllegalArgumentException("unsigned value [" + value + "] must be >= 0");
    }

    public static int bitSizeForUnsignedValue(long value) {
        if (value > 0L) {
            return 64 - Long.numberOfLeadingZeros(value);
        }
        if (value == 0L) {
            return 1;
        }
        throw new IllegalArgumentException("unsigned value [" + value + "] must be >= 0");
    }

    public static boolean isEven(int a) {
        return (a & 1) == 0;
    }

    public static boolean isEven(long a) {
        return NumbersUtils.isEven((int)a);
    }

    public static boolean isOdd(int a) {
        return (a & 1) != 0;
    }

    public static boolean isOdd(long a) {
        return NumbersUtils.isOdd((int)a);
    }

    public static boolean haveSameEvenness(int a, int b) {
        return ((a ^ b) & 1) == 0;
    }

    public static boolean haveSameEvenness(long a, long b) {
        return NumbersUtils.haveSameEvenness((int)a, (int)b);
    }

    public static boolean haveSameSign(int a, int b) {
        return (a ^ b) >= 0;
    }

    public static boolean haveSameSign(long a, long b) {
        return (a ^ b) >= 0L;
    }

    public static boolean isPowerOfTwo(int a) {
        if (a <= 0) {
            return false;
        }
        return (a & a - 1) == 0;
    }

    public static boolean isPowerOfTwo(long a) {
        if (a <= 0L) {
            return false;
        }
        return (a & a - 1L) == 0L;
    }

    public static boolean isSignedPowerOfTwo(int a) {
        if (a > 0) {
            return (a & a - 1) == 0;
        }
        if (a == -a) {
            return a != 0;
        }
        return (-a & -a - 1) == 0;
    }

    public static boolean isSignedPowerOfTwo(long a) {
        if (a > 0L) {
            return (a & a - 1L) == 0L;
        }
        if (a == -a) {
            return a != 0L;
        }
        return (-a & -a - 1L) == 0L;
    }

    public static int meanLow(int a, int b) {
        return (a & b) + ((a ^ b) >> 1);
    }

    public static long meanLow(long a, long b) {
        return (a & b) + ((a ^ b) >> 1);
    }

    public static int meanSml(int a, int b) {
        int result = NumbersUtils.meanLow(a, b);
        if (!NumbersUtils.haveSameEvenness(a, b) && ((a & b) < 0 || (a | b) < 0 && a + b < 0)) {
            ++result;
        }
        return result;
    }

    public static long meanSml(long a, long b) {
        long result = NumbersUtils.meanLow(a, b);
        if (!NumbersUtils.haveSameEvenness(a, b) && ((a & b) < 0L || (a | b) < 0L && a + b < 0L)) {
            ++result;
        }
        return result;
    }

    public static int negHalfWidth(int min, int max) {
        assert (min <= max);
        int mean = NumbersUtils.meanLow(min, max);
        return min - mean - ((min ^ max) & 1);
    }

    public static long negHalfWidth(long min, long max) {
        assert (min <= max);
        long mean = NumbersUtils.meanLow(min, max);
        return min - mean - ((min ^ max) & 1L);
    }

    public static int moduloSignedPowerOfTwo(int a, int spot) {
        assert (NumbersUtils.isSignedPowerOfTwo(spot));
        if (spot == Integer.MIN_VALUE) {
            return a != Integer.MIN_VALUE ? a : 0;
        }
        int s = a >> 31;
        return ((a + s ^ s) & NumbersUtils.abs(spot) - 1) + s ^ s;
    }

    public static long moduloSignedPowerOfTwo(long a, long spot) {
        assert (NumbersUtils.isSignedPowerOfTwo(spot));
        if (spot == Long.MIN_VALUE) {
            return a != Long.MIN_VALUE ? a : 0L;
        }
        long s = a >> 63;
        return ((a + s ^ s) & NumbersUtils.abs(spot) - 1L) + s ^ s;
    }

    public static int log2(int value) {
        if (value <= 0) {
            throw new IllegalArgumentException("value [" + value + "] must be > 0");
        }
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    public static int log2(long value) {
        if (value <= 0L) {
            throw new IllegalArgumentException("value [" + value + "] must be > 0");
        }
        return 63 - Long.numberOfLeadingZeros(value);
    }

    public static int abs(int value) {
        return (value ^ value >> 31) - (value >> 31);
    }

    public static long abs(long value) {
        return (value ^ value >> 63) - (value >> 63);
    }

    public static double twoPow(int power) {
        if (power <= -1023) {
            if (power >= -1074) {
                return Double.longBitsToDouble(0x8000000000000L >> -(power + 1023));
            }
            return 0.0;
        }
        if (power > 1023) {
            return Double.POSITIVE_INFINITY;
        }
        return Double.longBitsToDouble((long)(power + 1023) << 52);
    }

    public static int intHash(long value) {
        int hash = (int)(value >> 32) + (int)value;
        if (value < 0L) {
            ++hash;
        }
        return hash;
    }

    public static int toInt(long value) {
        if (value < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (value > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)value;
    }

    public static int toIntSafe(long value) {
        if (value < Integer.MIN_VALUE || value > Integer.MAX_VALUE) {
            throw new ArithmeticException("overflow: " + value);
        }
        return (int)value;
    }

    public static int plusNoModulo(int a, int b) {
        return NumbersUtils.toInt((long)a + (long)b);
    }

    public static int plusNoModuloSafe(int a, int b) {
        if ((a ^ b) < 0) {
            return a + b;
        }
        int sum = a + b;
        if ((a ^ sum) < 0) {
            throw new ArithmeticException("overflow: " + a + "+" + b);
        }
        return sum;
    }

    public static long plusNoModulo(long a, long b) {
        if ((a ^ b) < 0L) {
            return a + b;
        }
        long sum = a + b;
        if ((a ^ sum) < 0L) {
            return sum >= 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return sum;
    }

    public static long plusNoModuloSafe(long a, long b) {
        if ((a ^ b) < 0L) {
            return a + b;
        }
        long sum = a + b;
        if ((a ^ sum) < 0L) {
            throw new ArithmeticException("overflow: " + a + "+" + b);
        }
        return sum;
    }

    public static int minusNoModulo(int a, int b) {
        return NumbersUtils.toInt((long)a - (long)b);
    }

    public static int minusNoModuloSafe(int a, int b) {
        if ((a ^ b) >= 0) {
            return a - b;
        }
        int diff = a - b;
        if ((a ^ diff) < 0) {
            throw new ArithmeticException("overflow: " + a + "-" + b);
        }
        return diff;
    }

    public static long minusNoModulo(long a, long b) {
        if ((a ^ b) >= 0L) {
            return a - b;
        }
        long diff = a - b;
        if ((a ^ diff) < 0L) {
            return diff >= 0L ? Long.MIN_VALUE : Long.MAX_VALUE;
        }
        return diff;
    }

    public static long minusNoModuloSafe(long a, long b) {
        if ((a ^ b) >= 0L) {
            return a - b;
        }
        long diff = a - b;
        if ((a ^ diff) < 0L) {
            throw new ArithmeticException("overflow: " + a + "-" + b);
        }
        return diff;
    }

    public static int timesNoModulo(int a, int b) {
        return (int)((double)a * (double)b);
    }

    public static int timesNoModuloSafe(int a, int b) {
        double product = (double)a * (double)b;
        if (product >= -2.147483648E9 && product <= 2.147483647E9) {
            return (int)product;
        }
        throw new ArithmeticException("overflow: " + a + "*" + b);
    }

    public static long timesNoModulo(long a, long b) {
        if (b == 0L) {
            return 0L;
        }
        long product = a * b;
        if (product == Long.MIN_VALUE && (a ^ b) >= 0L) {
            return Long.MAX_VALUE;
        }
        if (product / b != a) {
            return (a ^ b) >= 0L ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
        return product;
    }

    public static long timesNoModuloSafe(long a, long b) {
        if (b == 0L) {
            return 0L;
        }
        long product = a * b;
        if (product == Long.MIN_VALUE && (a ^ b) >= 0L) {
            throw new ArithmeticException("overflow: " + a + "*" + b);
        }
        if (product / b != a) {
            throw new ArithmeticException("overflow: " + a + "*" + b);
        }
        return product;
    }

    public static boolean isNaNOrInfinite(double value) {
        return value - value != 0.0;
    }

    public static int pow2(int value) {
        return value * value;
    }

    public static long pow2(long value) {
        return value * value;
    }

    public static float pow2(float value) {
        return value * value;
    }

    public static double pow2(double value) {
        return value * value;
    }

    public static int pow3(int value) {
        return value * value * value;
    }

    public static long pow3(long value) {
        return value * value * value;
    }

    public static float pow3(float value) {
        return value * value * value;
    }

    public static double pow3(double value) {
        return value * value * value;
    }

    public static int toRange(int min, int max, int value) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static long toRange(long min, long max, long value) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static float toRange(float min, float max, float value) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }

    public static double toRange(double min, double max, double value) {
        if (value <= min) {
            return min;
        }
        if (value >= max) {
            return max;
        }
        return value;
    }
}

