/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.data.list;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.didion.jwnl.JWNL;
import net.didion.jwnl.data.PointerTarget;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.list.PointerTargetNode;
import net.didion.jwnl.data.list.PointerTargetNodeList;
import net.didion.jwnl.data.list.PointerTargetTreeNodeList;

public class PointerTargetTreeNode
extends PointerTargetNode {
    private PointerTargetTreeNodeList _childTreeList;
    private PointerTargetTreeNodeList _pointerTreeList;
    private PointerTargetTreeNode _parent;
    private transient String _cachedToString = null;

    public PointerTargetTreeNode(PointerTarget target, PointerTargetTreeNodeList childTreeList, PointerTargetTreeNodeList pointerTreeList, PointerType type, PointerTargetTreeNode parent) {
        super(target, type);
        this._parent = parent;
        this._childTreeList = childTreeList;
        this._pointerTreeList = pointerTreeList;
    }

    public PointerTargetTreeNode(PointerTarget target) {
        this(target, null, null, null, null);
    }

    public PointerTargetTreeNode(PointerTarget target, PointerType type) {
        this(target, null, null, type, null);
    }

    public PointerTargetTreeNode(PointerTarget target, PointerTargetTreeNodeList childTreeList, PointerType type) {
        this(target, childTreeList, null, type, null);
    }

    public PointerTargetTreeNode(PointerTarget target, PointerType type, PointerTargetTreeNode parent) {
        this(target, null, null, type, parent);
    }

    public PointerTargetTreeNode(PointerTarget target, PointerTargetTreeNodeList childTreeList, PointerType type, PointerTargetTreeNode parent) {
        this(target, childTreeList, null, type, parent);
    }

    public PointerTargetTreeNode(PointerTarget target, PointerTargetTreeNodeList childTreeList, PointerTargetTreeNodeList pointerTreeList, PointerType type) {
        this(target, childTreeList, pointerTreeList, type, null);
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PointerTargetTreeNode && super.equals(obj);
    }

    @Override
    public String toString() {
        if (this._cachedToString == null) {
            this._cachedToString = JWNL.resolveMessage("DATA_TOSTRING_015", new Object[]{this.getPointerTarget(), this.getType(), new Boolean(!this.hasParent()), new Boolean(this.hasValidChildTreeList()), new Boolean(this.hasValidPointerTreeList())});
        }
        return this._cachedToString;
    }

    public void setChildTreeList(PointerTargetTreeNodeList list) {
        this._childTreeList = list;
    }

    public void setPointerTreeList(PointerTargetTreeNodeList list) {
        this._pointerTreeList = list;
    }

    public void setParent(PointerTargetTreeNode parent) {
        this._parent = parent;
    }

    public PointerTargetTreeNode getParent() {
        return this._parent;
    }

    public PointerTargetTreeNodeList getChildTreeList() {
        return this._childTreeList;
    }

    public PointerTargetTreeNodeList getPointerTreeList() {
        return this._pointerTreeList;
    }

    public boolean hasChildTreeList() {
        return this.getChildTreeList() != null;
    }

    public boolean hasValidChildTreeList() {
        return this.hasChildTreeList() && !this.getChildTreeList().isEmpty();
    }

    public boolean hasPointerTreeList() {
        return this.getPointerTreeList() != null;
    }

    public boolean hasValidPointerTreeList() {
        return this.hasPointerTreeList() && !this.getPointerTreeList().isEmpty();
    }

    public boolean hasParent() {
        return this.getParent() != null;
    }

    public List toList(PointerTargetNodeList list) {
        try {
            list.add(this.getPointerTarget(), this.getType());
            ArrayList<PointerTargetNodeList> l = new ArrayList<PointerTargetNodeList>();
            if (this.hasValidChildTreeList()) {
                PointerTargetTreeNodeList childTreeList = this.getChildTreeList();
                ListIterator itr = childTreeList.listIterator();
                while (itr.hasNext()) {
                    l.addAll(((PointerTargetTreeNode)itr.next()).toList((PointerTargetNodeList)list.clone()));
                }
            } else {
                l.add(list);
            }
            return l;
        }
        catch (CloneNotSupportedException ex) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public Object clone() {
        return new PointerTargetTreeNode(this.getPointerTarget(), this.getChildTreeList(), this.getPointerTreeList(), this.getType(), this.getParent());
    }

    @Override
    public Object deepClone() throws UnsupportedOperationException {
        return new PointerTargetTreeNode(this.getPointerTarget(), (PointerTargetTreeNodeList)this.getChildTreeList().deepClone(), (PointerTargetTreeNodeList)this.getPointerTreeList().deepClone(), this.getType(), (PointerTargetTreeNode)this.getParent().deepClone());
    }
}

