/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.lazy;

import mulan.classifier.MultiLabelLearnerBase;
import mulan.data.MultiLabelInstances;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instances;
import weka.core.neighboursearch.LinearNNSearch;

public abstract class MultiLabelKNN
extends MultiLabelLearnerBase {
    protected int distanceWeighting;
    public static final int WEIGHT_NONE = 1;
    public static final int WEIGHT_INVERSE = 2;
    public static final int WEIGHT_SIMILARITY = 4;
    protected int numOfNeighbors;
    protected LinearNNSearch lnn = null;
    protected DistanceFunction dfunc = null;
    protected Instances train;

    public void setDfunc(DistanceFunction dfunc) {
        this.dfunc = dfunc;
    }

    public MultiLabelKNN() {
        this.numOfNeighbors = 10;
        this.dfunc = new EuclideanDistance();
    }

    public MultiLabelKNN(int numOfNeighbors) {
        this.numOfNeighbors = numOfNeighbors;
        this.dfunc = new EuclideanDistance();
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainSet) throws Exception {
        if (trainSet.getNumInstances() < this.numOfNeighbors) {
            throw new IllegalArgumentException("The number of training instances is less than the number of requested nearest neighbours");
        }
        this.train = new Instances(trainSet.getDataSet());
        String labelIndicesString = "";
        for (int i = 0; i < this.numLabels - 1; ++i) {
            labelIndicesString = labelIndicesString + (this.labelIndices[i] + 1) + ",";
        }
        labelIndicesString = labelIndicesString + (this.labelIndices[this.numLabels - 1] + 1);
        this.dfunc.setAttributeIndices(labelIndicesString);
        this.dfunc.setInvertSelection(true);
        this.lnn = new LinearNNSearch();
        this.lnn.setDistanceFunction(this.dfunc);
        this.lnn.setInstances(this.train);
        this.lnn.setMeasurePerformance(false);
    }

    @Override
    public boolean isUpdatable() {
        return true;
    }

    public void setDistanceWeighting(int distanceWeighting) {
        this.distanceWeighting = distanceWeighting;
    }
}

