/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta;

import java.util.ArrayList;
import java.util.HashSet;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.data.MultiLabelInstances;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class HMCNode
extends MultiLabelMetaLearner {
    private String nodeName;
    private HashSet<HMCNode> children = null;
    private Instances header;

    public int[] getLabelIndices() {
        return this.labelIndices;
    }

    public HMCNode(String name, MultiLabelLearner mlc) throws Exception {
        super(mlc);
        this.nodeName = name;
    }

    public Instances getHeader() {
        return this.header;
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingSet) throws Exception {
        this.header = new Instances(trainingSet.getDataSet(), 0);
        this.baseLearner.build(trainingSet);
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        return this.baseLearner.makePrediction(instance);
    }

    public boolean hasChildren() {
        return this.children != null;
    }

    public int getNumChildren() {
        return this.children.size();
    }

    public HashSet<HMCNode> getChildren() {
        return this.children;
    }

    public ArrayList<String> getChildrenLabels() {
        ArrayList<String> childrenLabels = new ArrayList<String>();
        for (HMCNode child : this.getChildren()) {
            childrenLabels.add(child.getName());
        }
        return childrenLabels;
    }

    public ArrayList<String> getDescendantLabels() {
        ArrayList<String> descendantLabels = new ArrayList<String>();
        if (this.getChildren() != null) {
            for (HMCNode child : this.getChildren()) {
                descendantLabels.add(child.getName());
                descendantLabels.addAll(child.getDescendantLabels());
            }
        }
        return descendantLabels;
    }

    public void addChild(HMCNode child) {
        if (this.children == null) {
            this.children = new HashSet();
        }
        this.children.add(child);
    }

    public String getName() {
        return this.nodeName;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String globalInfo() {
        return "Class implementing a node in the Hierarchy Of Multi-labEl leaRners algorithm. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }
}

