/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta;

import java.util.Set;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.HMC;
import mulan.classifier.meta.HierarchyBuilder;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.DataUtils;
import mulan.data.LabelsMetaData;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;

public class HOMER
extends MultiLabelMetaLearner {
    private final int numClusters;
    private HMC hmc;
    private HierarchyBuilder hb;
    private Instances header;
    private HierarchyBuilder.Method method;
    private MultiLabelInstances m;
    private int numMetaLabels;

    public HOMER() {
        super(new BinaryRelevance((Classifier)new J48()));
        this.method = HierarchyBuilder.Method.BalancedClustering;
        this.numClusters = 3;
    }

    public HOMER(MultiLabelLearner mll, int clusters, HierarchyBuilder.Method method) {
        super(mll);
        this.method = method;
        this.numClusters = clusters;
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingSet) throws Exception {
        this.debug("Learning the hierarchy of models");
        this.hb = new HierarchyBuilder(this.numClusters, this.method);
        LabelsMetaData labelHierarchy = this.hb.buildLabelHierarchy(trainingSet);
        this.debug("Constructing the hierarchical multilabel dataset");
        MultiLabelInstances meta = HierarchyBuilder.createHierarchicalDataset(trainingSet, labelHierarchy);
        this.header = new Instances(meta.getDataSet(), 0);
        this.debug("Training the hierarchical classifier");
        this.hmc = new HMC(this.baseLearner);
        this.hmc.setDebug(this.getDebug());
        this.hmc.build(meta);
        Set<String> leafLabels = trainingSet.getLabelsMetaData().getLabelNames();
        Set<String> metaLabels = labelHierarchy.getLabelNames();
        for (String string : leafLabels) {
            metaLabels.remove(string);
        }
        this.numMetaLabels = metaLabels.size();
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        Instance transformed = DataUtils.createInstance(instance, instance.weight(), instance.toDoubleArray());
        for (int i = 0; i < this.numMetaLabels; ++i) {
            transformed.insertAttributeAt(transformed.numAttributes());
        }
        transformed.setDataset(this.header);
        MultiLabelOutput mlo = this.hmc.makePrediction(transformed);
        boolean[] oldBipartition = mlo.getBipartition();
        boolean[] newBipartition = new boolean[this.numLabels];
        System.arraycopy(oldBipartition, 0, newBipartition, 0, this.numLabels);
        double[] oldConfidences = mlo.getConfidences();
        double[] newConfidences = new double[this.numLabels];
        System.arraycopy(oldConfidences, 0, newConfidences, 0, this.numLabels);
        MultiLabelOutput newMLO = new MultiLabelOutput(newBipartition, newConfidences);
        return newMLO;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Grigorios Tsoumakas and Ioannis Katakis and Ioannis Vlahavas");
        result.setValue(TechnicalInformation.Field.TITLE, "Effective and Efficient Multilabel Classification in Domains with Large Number of Labels");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proc. ECML/PKDD 2008 Workshop on Mining Multidimensional Data (MMD'08)");
        result.setValue(TechnicalInformation.Field.LOCATION, "Antwerp, Belgium");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        return result;
    }

    public long getNoNodes() {
        return this.hmc.getNoNodes();
    }

    public long getNoClassifierEvals() {
        return this.hmc.getNoClassifierEvals();
    }

    public long getTotalUsedTrainInsts() {
        return this.hmc.getTotalUsedTrainInsts();
    }

    @Override
    public String globalInfo() {
        return "Class implementing the Hierarchy Of Multi-labEl leaRners algorithm. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }
}

