/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.Remove;

public class RAkELd
extends MultiLabelMetaLearner {
    private int seed = 0;
    private Random rnd = new Random();
    int numOfModels;
    int sizeOfSubset = 3;
    ArrayList<Integer>[] classIndicesPerSubset_d;
    ArrayList<Integer>[] absoluteIndicesToRemove;
    ArrayList<Integer> listOfLabels;
    MultiLabelLearner[] subsetClassifiers;
    private Remove[] remove;

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.ARTICLE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Grigorios Tsoumakas and Ioannis Katakis and Ioannis Vlahavas");
        result.setValue(TechnicalInformation.Field.TITLE, "Random k-Labelsets for Multi-Label Classification");
        result.setValue(TechnicalInformation.Field.JOURNAL, "IEEE Transactions on Knowledge and Data Engineering");
        result.setValue(TechnicalInformation.Field.PAGES, "1079-1089");
        result.setValue(TechnicalInformation.Field.VOLUME, "23");
        result.setValue(TechnicalInformation.Field.NUMBER, "7");
        result.setValue(TechnicalInformation.Field.YEAR, "2011");
        return result;
    }

    public RAkELd() {
        this(new BinaryRelevance((Classifier)new J48()));
    }

    public RAkELd(MultiLabelLearner baseLearner) {
        super(baseLearner);
    }

    public RAkELd(MultiLabelLearner baseLearner, int subset) {
        super(baseLearner);
        this.sizeOfSubset = subset;
    }

    public void setSeed(int x) {
        this.seed = x;
        this.rnd = new Random(this.seed);
    }

    public void setSizeOfSubset(int size) {
        this.sizeOfSubset = size;
    }

    public int getSizeOfSubset() {
        return this.sizeOfSubset;
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingData) throws Exception {
        int i;
        this.numOfModels = this.numLabels % this.sizeOfSubset == 0 || this.numLabels % this.sizeOfSubset == 1 ? this.numLabels / this.sizeOfSubset : this.numLabels / this.sizeOfSubset + 1;
        this.classIndicesPerSubset_d = new ArrayList[this.numOfModels];
        for (i = 0; i < this.numOfModels; ++i) {
            this.classIndicesPerSubset_d[i] = new ArrayList();
        }
        this.absoluteIndicesToRemove = new ArrayList[this.numOfModels];
        for (i = 0; i < this.numOfModels; ++i) {
            this.absoluteIndicesToRemove[i] = new ArrayList();
        }
        this.subsetClassifiers = new MultiLabelLearner[this.numOfModels];
        this.remove = new Remove[this.numOfModels];
        this.listOfLabels = new ArrayList();
        for (int c = 0; c < this.numLabels; ++c) {
            this.listOfLabels.add(c);
        }
        for (i = 0; i < this.numOfModels; ++i) {
            this.updateClassifier(trainingData, i);
        }
    }

    public void updateClassifier(MultiLabelInstances mlTrainData, int model) throws Exception {
        int j;
        Instances trainData = mlTrainData.getDataSet();
        if (model == this.numOfModels - 1) {
            this.classIndicesPerSubset_d[model].addAll(this.listOfLabels);
        } else {
            for (j = 0; j < this.sizeOfSubset; ++j) {
                int randomLabelIndex = Math.abs(this.rnd.nextInt() % this.listOfLabels.size());
                int randomLabel = this.listOfLabels.get(randomLabelIndex);
                this.listOfLabels.remove(randomLabelIndex);
                this.classIndicesPerSubset_d[model].add(randomLabel);
            }
        }
        Collections.sort(this.classIndicesPerSubset_d[model]);
        this.debug("Building model " + (model + 1) + "/" + this.numOfModels + ", subset: " + this.classIndicesPerSubset_d[model].toString());
        for (int j2 = 0; j2 < this.numLabels; ++j2) {
            if (this.classIndicesPerSubset_d[model].contains(j2)) continue;
            this.absoluteIndicesToRemove[model].add(this.labelIndices[j2]);
        }
        int[] indicesRemoveArray = new int[this.absoluteIndicesToRemove[model].size()];
        for (j = 0; j < indicesRemoveArray.length; ++j) {
            indicesRemoveArray[j] = this.absoluteIndicesToRemove[model].get(j);
        }
        this.remove[model] = new Remove();
        this.remove[model].setInvertSelection(false);
        this.remove[model].setAttributeIndicesArray(indicesRemoveArray);
        this.remove[model].setInputFormat(trainData);
        Instances trainSubset = Filter.useFilter((Instances)trainData, (Filter)this.remove[model]);
        this.subsetClassifiers[model] = this.getBaseLearner().makeCopy();
        this.subsetClassifiers[model].build(mlTrainData.reintegrateModifiedDataSet(trainSubset));
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception {
        double[] confidences = new double[this.numLabels];
        boolean[] labels = new boolean[this.numLabels];
        for (int i = 0; i < this.numOfModels; ++i) {
            this.remove[i].input(instance);
            this.remove[i].batchFinished();
            Instance newInstance = this.remove[i].output();
            MultiLabelOutput subsetMLO = this.subsetClassifiers[i].makePrediction(newInstance);
            boolean[] localPredictions = subsetMLO.getBipartition();
            double[] localConfidences = subsetMLO.getConfidences();
            for (int j = 0; j < this.classIndicesPerSubset_d[i].size(); ++j) {
                labels[this.classIndicesPerSubset_d[i].get((int)j).intValue()] = localPredictions[j];
                confidences[this.classIndicesPerSubset_d[i].get((int)j).intValue()] = localConfidences[j];
            }
        }
        MultiLabelOutput mlo = new MultiLabelOutput(labels, confidences);
        return mlo;
    }

    @Override
    public String globalInfo() {
        return "Class implementing a generalized version of the RAkEL-d (RAndom k-labELsets) algorithm with disjoint labelsets. For more information, see\n\n" + this.getTechnicalInformation().toString();
    }
}

