/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.meta.thresholding;

import java.util.Arrays;
import mulan.classifier.InvalidDataException;
import mulan.classifier.MultiLabelLearner;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.meta.MultiLabelMetaLearner;
import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.MultiLabelInstances;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.TechnicalInformation;
import weka.core.Utils;

public class ExampleBasedFMeasureOptimizer
extends MultiLabelMetaLearner {
    public ExampleBasedFMeasureOptimizer(MultiLabelLearner baseLearner) {
        super(baseLearner);
    }

    public ExampleBasedFMeasureOptimizer() {
        this(new BinaryRelevance((Classifier)new J48()));
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingSet) throws Exception {
        this.baseLearner.build(trainingSet);
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception, InvalidDataException {
        MultiLabelOutput mlo = this.baseLearner.makePrediction(instance);
        double[] marginals = mlo.getConfidences();
        boolean[] bipartition = this.bipartitionFromMarginals(marginals);
        mlo = new MultiLabelOutput(bipartition, marginals);
        return mlo;
    }

    private boolean[] bipartitionFromMarginals(double[] confidences) {
        int i;
        boolean[] bipartition = new boolean[this.numLabels];
        int[] sortedIndices = Utils.stableSort((double[])confidences);
        double[] sortedConfidences = Arrays.copyOfRange(confidences, 0, confidences.length);
        Arrays.sort(sortedConfidences);
        double BestF = 0.0;
        double topN = 0.0;
        for (i = 0; i < this.numLabels; ++i) {
            double nominator = 0.0;
            double denom1 = 0.0;
            double denom2 = 0.0;
            for (int j = 0; j < this.numLabels; ++j) {
                double h = j > i ? 0.0 : 1.0;
                nominator += sortedConfidences[this.numLabels - 1 - j] * h;
                denom1 += sortedConfidences[this.numLabels - 1 - j];
                denom2 += h;
            }
            double F = 2.0 * nominator / (denom1 + denom2);
            if (!(F > BestF)) continue;
            BestF = F;
            topN += 1.0;
        }
        if (topN == 0.0) {
            topN = 1.0;
        }
        i = 0;
        while ((double)i < topN) {
            bipartition[sortedIndices[this.numLabels - 1 - i]] = true;
            ++i;
        }
        return bipartition;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "David Lewis");
        result.setValue(TechnicalInformation.Field.TITLE, "Evaluating and optimizing autonomous text classification systems");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 18th annual international ACM SIGIR conference on Research and development in information retrieval (SIGIR 1995)");
        result.setValue(TechnicalInformation.Field.YEAR, "1995");
        return result;
    }

    @Override
    public String globalInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("This class takes the marginal probabilities estimated for ");
        sb.append("each label by a multi-label learner and transforms them ");
        sb.append("into a bipartition which is approximately optimal for ");
        sb.append("example-based FMeasure. This optimizer assumes ");
        sb.append("independence of the target variables (labels) and the ");
        sb.append("optimal solution always contains the labels with the ");
        sb.append("highest marginal probabilities. For more information, ");
        sb.append("see\n\n").append(this.getTechnicalInformation().toString());
        return sb.toString();
    }
}

