/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.InvalidDataException;
import mulan.classifier.MultiLabelOutput;
import mulan.classifier.transformation.PrunedSets;
import mulan.classifier.transformation.TransformationBasedMultiLabelLearner;
import mulan.data.MultiLabelInstances;
import weka.classifiers.AbstractClassifier;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.TechnicalInformation;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemovePercentage;

public class EnsembleOfPrunedSets
extends TransformationBasedMultiLabelLearner {
    protected double threshold;
    protected int numOfModels;
    protected double percentage;
    protected PrunedSets[] ensemble;
    protected Random rand;

    public EnsembleOfPrunedSets() {
        this(66.0, 10, 0.5, 2, PrunedSets.Strategy.A, 3, (Classifier)new J48());
    }

    public EnsembleOfPrunedSets(double aPercentage, int aNumOfModels, double aThreshold, int aP, PrunedSets.Strategy aStrategy, int aB, Classifier baselearner) {
        super(baselearner);
        this.numOfModels = aNumOfModels;
        this.threshold = aThreshold;
        this.percentage = aPercentage;
        this.ensemble = new PrunedSets[this.numOfModels];
        for (int i = 0; i < this.numOfModels; ++i) {
            try {
                this.ensemble[i] = new PrunedSets(AbstractClassifier.makeCopy((Classifier)baselearner), aP, aStrategy, aB);
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger(EnsembleOfPrunedSets.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.rand = new Random(1L);
    }

    @Override
    protected void buildInternal(MultiLabelInstances trainingSet) throws Exception {
        Instances dataSet = new Instances(trainingSet.getDataSet());
        for (int i = 0; i < this.numOfModels; ++i) {
            dataSet.randomize(this.rand);
            RemovePercentage rmvp = new RemovePercentage();
            rmvp.setInputFormat(dataSet);
            rmvp.setPercentage(this.percentage);
            rmvp.setInvertSelection(true);
            Instances trainDataSet = Filter.useFilter((Instances)dataSet, (Filter)rmvp);
            MultiLabelInstances train = new MultiLabelInstances(trainDataSet, trainingSet.getLabelsMetaData());
            this.ensemble[i].build(train);
        }
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.CONFERENCE);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Read, Jesse and Pfahringer, Bernhard and Holmes, Geoff");
        result.setValue(TechnicalInformation.Field.TITLE, "Multi-label Classification using Ensembles of Pruned Sets");
        result.setValue(TechnicalInformation.Field.PAGES, "995-1000");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "ICDM'08: Eighth IEEE International Conference on Data Mining");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        return result;
    }

    @Override
    public String globalInfo() {
        return "Class implementing the Ensemble of Pruned Sets algorithm(EPS) . For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    protected MultiLabelOutput makePredictionInternal(Instance instance) throws Exception, InvalidDataException {
        int[] sumVotes = new int[this.numLabels];
        for (int i = 0; i < this.numOfModels; ++i) {
            MultiLabelOutput ensembleMLO = this.ensemble[i].makePrediction(instance);
            boolean[] bip = ensembleMLO.getBipartition();
            for (int j = 0; j < sumVotes.length; ++j) {
                int n = j;
                sumVotes[n] = sumVotes[n] + (bip[j] ? 1 : 0);
            }
        }
        double[] confidence = new double[this.numLabels];
        for (int j = 0; j < sumVotes.length; ++j) {
            confidence[j] = (double)sumVotes[j] / (double)this.numOfModels;
        }
        MultiLabelOutput mlo = new MultiLabelOutput(confidence, this.threshold);
        return mlo;
    }
}

