/*
 * Decompiled with CFR 0.152.
 */
package mulan.classifier.transformation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.classifier.transformation.LabelsetPruning;
import mulan.data.DataUtils;
import mulan.data.LabelSet;
import weka.classifiers.Classifier;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.TechnicalInformation;

public class PPT
extends LabelsetPruning {
    private Strategy strategy;

    public PPT() {
        this((Classifier)new J48(), 3, Strategy.NO_INFORMATION_LOSS);
    }

    public PPT(Classifier classifier, int p, Strategy aStrategy) {
        super(classifier, p);
        this.strategy = aStrategy;
        this.setConfidenceCalculationMethod(2);
        this.setMakePredictionsBasedOnConfidences(true);
        this.threshold = 0.21;
    }

    @Override
    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation result = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        result.setValue(TechnicalInformation.Field.AUTHOR, "Read, Jesse");
        result.setValue(TechnicalInformation.Field.TITLE, "A Pruned Problem Transformation Method for Multi-label classification");
        result.setValue(TechnicalInformation.Field.PAGES, "143-150");
        result.setValue(TechnicalInformation.Field.BOOKTITLE, "Proc. 2008 New Zealand Computer Science Research Student Conference (NZCSRS 2008)");
        result.setValue(TechnicalInformation.Field.YEAR, "2008");
        return result;
    }

    @Override
    public String globalInfo() {
        return "Class implementing the Pruned Problem Transformation algorithm (PPT) . For more information, see\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    ArrayList<Instance> processRejected(LabelSet ls) {
        switch (this.strategy) {
            case INFORMATION_LOSS: {
                return new ArrayList<Instance>();
            }
            case NO_INFORMATION_LOSS: {
                ArrayList<LabelSet> subsets = null;
                try {
                    subsets = ls.getSubsets();
                }
                catch (Exception ex) {
                    Logger.getLogger(PPT.class.getName()).log(Level.SEVERE, null, ex);
                }
                Collections.sort(subsets);
                ArrayList<LabelSet> subsetsForInsertion = new ArrayList<LabelSet>();
                for (LabelSet l : subsets) {
                    if (!this.ListInstancePerLabel.containsKey(l) || ((ArrayList)this.ListInstancePerLabel.get(l)).size() <= this.p) continue;
                    boolean foundCommon = false;
                    for (LabelSet l2 : subsetsForInsertion) {
                        LabelSet temp = LabelSet.intersection(l, l2);
                        if (temp.size() == 0) continue;
                        foundCommon = true;
                        break;
                    }
                    if (foundCommon) continue;
                    subsetsForInsertion.add(l);
                }
                ArrayList instances = (ArrayList)this.ListInstancePerLabel.get(ls);
                ArrayList<Instance> newInstances = new ArrayList<Instance>();
                for (Instance tempInstance : instances) {
                    for (LabelSet l : subsetsForInsertion) {
                        double[] temp = tempInstance.toDoubleArray();
                        double[] tempLabels = l.toDoubleArray();
                        for (int i = 0; i < this.numLabels; ++i) {
                            temp[this.labelIndices[i]] = this.format.attribute(this.labelIndices[i]).value(0).equals("0") ? tempLabels[i] : 1.0 - tempLabels[i];
                        }
                        Instance newInstance = DataUtils.createInstance(tempInstance, 1.0, temp);
                        newInstances.add(newInstance);
                    }
                }
                return newInstances;
            }
        }
        return null;
    }

    public static enum Strategy {
        INFORMATION_LOSS,
        NO_INFORMATION_LOSS;

    }
}

