/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import mulan.data.LabelNodeImpl;
import mulan.data.LabelsBuilder;
import mulan.data.LabelsBuilderException;
import mulan.data.LabelsMetaData;
import mulan.data.LabelsMetaDataImpl;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.SparseInstance;
import weka.core.Utils;

public class ConverterLibSVM {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convertFromLibSVM(String path, String sourceFilename, String targetFilestem, String relationName) {
        BufferedReader aReader = null;
        BufferedWriter aWriter = null;
        int numLabels = 0;
        int numAttributes = 0;
        int numInstances = 0;
        double meanParsedAttributes = 0.0;
        String Line = null;
        try {
            aReader = new BufferedReader(new FileReader(path + sourceFilename));
            while ((Line = aReader.readLine()) != null) {
                ++numInstances;
                StringTokenizer strTok = new StringTokenizer(Line, " ");
                while (strTok.hasMoreTokens()) {
                    String token = strTok.nextToken();
                    if (token.indexOf(":") == -1) {
                        StringTokenizer labelTok = new StringTokenizer(token, ",");
                        while (labelTok.hasMoreTokens()) {
                            String strLabel = labelTok.nextToken();
                            int intLabel = Integer.parseInt(strLabel);
                            if (intLabel <= numLabels) continue;
                            numLabels = intLabel;
                        }
                        continue;
                    }
                    meanParsedAttributes += 1.0;
                    StringTokenizer attrTok = new StringTokenizer(token, ":");
                    String strAttrIndex = attrTok.nextToken();
                    int intAttrIndex = Integer.parseInt(strAttrIndex);
                    if (intAttrIndex <= numAttributes) continue;
                    numAttributes = intAttrIndex;
                }
            }
            System.out.println("Number of attributes: " + numAttributes);
            System.out.println("Number of instances: " + numInstances);
            System.out.println("Number of classes: " + ++numLabels);
            System.out.println("Constructing XML file... ");
            LabelsMetaDataImpl meta = new LabelsMetaDataImpl();
            for (int label = 0; label < numLabels; ++label) {
                meta.addRootNode(new LabelNodeImpl("Label" + (label + 1)));
            }
            String labelsFilePath = path + targetFilestem + ".xml";
            try {
                LabelsBuilder.dumpLabels((LabelsMetaData)meta, labelsFilePath);
                System.out.println("Done!");
            }
            catch (LabelsBuilderException e) {
                File labelsFile = new File(labelsFilePath);
                if (labelsFile.exists()) {
                    labelsFile.delete();
                }
                System.out.println("Construction of labels XML failed!");
            }
            meanParsedAttributes /= (double)numInstances;
            boolean Sparse = false;
            if (meanParsedAttributes < (double)numAttributes) {
                Sparse = true;
                System.out.println("Dataset is sparse.");
            }
            ArrayList<Attribute> attInfo = new ArrayList<Attribute>(numAttributes + numLabels);
            Attribute[] att = new Attribute[numAttributes + numLabels];
            for (int i = 0; i < numAttributes; ++i) {
                att[i] = new Attribute("Att" + (i + 1));
                attInfo.add(att[i]);
            }
            ArrayList<String> ClassValues = new ArrayList<String>(2);
            ClassValues.add("0");
            ClassValues.add("1");
            for (int i = 0; i < numLabels; ++i) {
                att[numAttributes + i] = new Attribute("Label" + (i + 1), ClassValues);
                attInfo.add(att[numAttributes + i]);
            }
            int countInstances = 0;
            aWriter = new BufferedWriter(new FileWriter(path + targetFilestem + ".arff"));
            Instances data = new Instances(relationName, attInfo, 0);
            aWriter.write(data.toString());
            aReader = new BufferedReader(new FileReader(path + sourceFilename));
            while ((Line = aReader.readLine()) != null) {
                ++countInstances;
                double[] attValues = new double[numAttributes + numLabels];
                Arrays.fill(attValues, 0.0);
                DenseInstance tempInstance = new DenseInstance(1.0, attValues);
                tempInstance.setDataset(data);
                StringTokenizer strTok = new StringTokenizer(Line, " ");
                while (strTok.hasMoreTokens()) {
                    String token = strTok.nextToken();
                    if (token.indexOf(":") == -1) {
                        StringTokenizer labelTok = new StringTokenizer(token, ",");
                        while (labelTok.hasMoreTokens()) {
                            String strLabel = labelTok.nextToken();
                            int intLabel = Integer.parseInt(strLabel);
                            tempInstance.setValue(numAttributes + intLabel, 1.0);
                        }
                        continue;
                    }
                    StringTokenizer AttrTok = new StringTokenizer(token, ":");
                    String strAttrIndex = AttrTok.nextToken();
                    String strAttrValue = AttrTok.nextToken();
                    tempInstance.setValue(Integer.parseInt(strAttrIndex) - 1, Double.parseDouble(strAttrValue));
                }
                if (Sparse) {
                    SparseInstance tempSparseInstance = new SparseInstance((Instance)tempInstance);
                    aWriter.write(tempSparseInstance.toString() + "\n");
                    continue;
                }
                aWriter.write(tempInstance.toString() + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (aReader != null) {
                    aReader.close();
                }
                if (aWriter != null) {
                    aWriter.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static void createLabelsMetadataFile(String filePath, int numLabels) throws LabelsBuilderException {
    }

    public static void main(String[] args) {
        String path = null;
        String source = null;
        String target = null;
        String relationName = "LibSVM";
        try {
            path = Utils.getOption((String)"path", (String[])args);
            source = Utils.getOption((String)"source", (String[])args);
            target = Utils.getOption((String)"target", (String[])args);
            relationName = Utils.getOption((String)"name", (String[])args);
            ConverterLibSVM.convertFromLibSVM(path, source, target, relationName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

