/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import mulan.core.ArgumentNullException;
import mulan.data.LabelNodeImpl;
import mulan.data.LabelsBuilderException;
import mulan.data.LabelsMetaData;
import mulan.data.LabelsMetaDataImpl;
import org.xml.sax.SAXException;

public final class LabelsBuilder {
    private static final String LABELS_SCHEMA_SOURCE = "mulan/data/labels.xsd";
    protected static final String LABELS_SCHEMA_NAMESPACE = "http://mulan.sourceforge.net/labels";
    private static final String SCHEMA_FULL_CHECKING_FEATURE = "http://apache.org/xml/features/validation/schema-full-checking";

    public static LabelsMetaData createLabels(String xmlLabelsFilePath) throws LabelsBuilderException {
        LabelsMetaData result;
        if (xmlLabelsFilePath == null) {
            throw new ArgumentNullException("xmlLabelsFilePath");
        }
        File xmlDefFile = new File(xmlLabelsFilePath);
        if (!xmlDefFile.exists()) {
            throw new IllegalArgumentException(String.format("The specified XML file source '%s' does not exist.", xmlDefFile.getAbsolutePath()));
        }
        BufferedInputStream xmlFileInputStream = null;
        try {
            xmlFileInputStream = new BufferedInputStream(new FileInputStream(xmlDefFile));
            result = LabelsBuilder.createLabels(xmlFileInputStream);
        }
        catch (FileNotFoundException e) {
            throw new LabelsBuilderException(String.format("Error when creating input stream for the file under path: '%s'.", xmlLabelsFilePath));
        }
        finally {
            if (xmlFileInputStream != null) {
                try {
                    xmlFileInputStream.close();
                }
                catch (IOException e) {}
            }
        }
        return result;
    }

    public static LabelsMetaData createLabels(InputStream inputStream) throws LabelsBuilderException {
        if (inputStream == null) {
            throw new ArgumentNullException("inputStream");
        }
        LabelsMetaDataImpl result = null;
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature(SCHEMA_FULL_CHECKING_FEATURE, false);
            Schema schema = schemaFactory.newSchema(LabelsBuilder.class.getClassLoader().getResource(LABELS_SCHEMA_SOURCE));
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LabelsMetaDataImpl.class, LabelNodeImpl.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            unmarshaller.setSchema(schema);
            unmarshaller.setListener((Unmarshaller.Listener)new UnmarshallingProcessor());
            result = (LabelsMetaDataImpl)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException exception) {
            throw new LabelsBuilderException("Error when trying to create objects structure from XML source.", exception);
        }
        catch (SAXException exception) {
            throw new LabelsBuilderException("Error when creating schema instance to validate the XML source for labels creation.", exception);
        }
        return result;
    }

    public static void dumpLabels(LabelsMetaData labelsMetaData, String xmlDumpFilePath) throws LabelsBuilderException {
        if (xmlDumpFilePath == null) {
            throw new ArgumentNullException("xmlDumpFilePath");
        }
        File xmlDumpFile = new File(xmlDumpFilePath);
        boolean fileExists = xmlDumpFile.exists();
        FilterOutputStream fileOutStream = null;
        try {
            if (!fileExists) {
                xmlDumpFile.createNewFile();
            }
            fileOutStream = new BufferedOutputStream(new FileOutputStream(xmlDumpFile));
            LabelsBuilder.dumpLabels(labelsMetaData, fileOutStream);
        }
        catch (IOException exception) {
            if (!fileExists) {
                xmlDumpFile.delete();
            }
            throw new LabelsBuilderException("Error creating file output stream, to which labels meta-data has to be dumped.");
        }
        finally {
            if (fileOutStream != null) {
                try {
                    fileOutStream.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    public static void dumpLabels(LabelsMetaData labelsMetaData, OutputStream outputStream) throws LabelsBuilderException {
        if (outputStream == null) {
            throw new ArgumentNullException("outputStream");
        }
        if (!(labelsMetaData instanceof LabelsMetaDataImpl)) {
            throw new IllegalArgumentException(String.format("The specified implementation of labels meta data '%s' is not supported.", labelsMetaData.getClass().getName()));
        }
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setFeature(SCHEMA_FULL_CHECKING_FEATURE, false);
            Schema schema = schemaFactory.newSchema(ClassLoader.getSystemResource(LABELS_SCHEMA_SOURCE));
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LabelsMetaDataImpl.class, LabelNodeImpl.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            marshaller.setSchema(schema);
            marshaller.marshal((Object)labelsMetaData, outputStream);
        }
        catch (JAXBException exception) {
            throw new LabelsBuilderException("Error when trying to dump labels meta-data objects structure to XML file.", exception);
        }
        catch (SAXException exception) {
            throw new LabelsBuilderException("Error when creating schema instance to validate XML dump of labels meta-data objects structure.", exception);
        }
    }

    private static class UnmarshallingProcessor
    extends Unmarshaller.Listener {
        private UnmarshallingProcessor() {
        }

        public void afterUnmarshal(Object target, Object parent) {
            if (parent instanceof LabelNodeImpl && target instanceof LabelNodeImpl) {
                ((LabelNodeImpl)target).setParent((LabelNodeImpl)parent);
            }
            if (target instanceof LabelsMetaDataImpl && parent == null) {
                ((LabelsMetaDataImpl)target).doReInit();
            }
        }
    }
}

