/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import mulan.core.ArgumentNullException;
import mulan.core.MulanRuntimeException;
import mulan.core.WekaException;
import mulan.data.LabelNode;
import mulan.data.LabelNodeImpl;
import mulan.data.LabelsMetaData;
import weka.core.SerializedObject;

@XmlRootElement(name="labels", namespace="http://mulan.sourceforge.net/labels")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(name="labelsRootType", propOrder={"rootLabelNodes"})
public class LabelsMetaDataImpl
implements LabelsMetaData,
Serializable,
Externalizable {
    private static final long serialVersionUID = 5098050799557336378L;
    private Map<String, LabelNode> allLabelNodes = new HashMap<String, LabelNode>();
    @XmlElement(type=LabelNodeImpl.class, name="label", required=true, namespace="http://mulan.sourceforge.net/labels")
    private Set<LabelNode> rootLabelNodes = new HashSet<LabelNode>();

    public void addRootNode(LabelNode rootNode) {
        if (rootNode == null) {
            throw new ArgumentNullException("rootNode");
        }
        if (this.rootLabelNodes.contains(rootNode)) {
            throw new IllegalArgumentException(String.format("The root label node '%s' is already added.", rootNode.getName()));
        }
        this.rootLabelNodes.add(rootNode);
        this.processNodeIndex(rootNode, IndexingAction.Add);
    }

    @Override
    public LabelNode getLabelNode(String labelName) {
        return this.allLabelNodes.get(labelName);
    }

    @Override
    public Set<String> getLabelNames() {
        return new HashSet<String>(this.allLabelNodes.keySet());
    }

    @Override
    public boolean containsLabel(String labelName) {
        return this.allLabelNodes.containsKey(labelName);
    }

    @Override
    public boolean isHierarchy() {
        return this.allLabelNodes.size() != this.rootLabelNodes.size();
    }

    @Override
    public int getNumLabels() {
        return this.allLabelNodes.size();
    }

    @Override
    public Set<LabelNode> getRootLabels() {
        return Collections.unmodifiableSet(this.rootLabelNodes);
    }

    @Override
    public LabelsMetaData clone() {
        Set rootNodes = null;
        try {
            SerializedObject obj = new SerializedObject(this.rootLabelNodes);
            rootNodes = (Set)obj.getObject();
        }
        catch (Exception ex) {
            throw new WekaException("Failed to create copy of 'root label nodes'.", ex);
        }
        LabelsMetaDataImpl copyResult = new LabelsMetaDataImpl();
        for (LabelNode rootNode : rootNodes) {
            copyResult.addRootNode(rootNode);
        }
        return copyResult;
    }

    public int removeLabelNode(String labelName) {
        if (!this.allLabelNodes.containsKey(labelName)) {
            return 0;
        }
        LabelNode labelNode = this.allLabelNodes.get(labelName);
        int result = this.processNodeIndex(labelNode, IndexingAction.Remove);
        if (result > 0 && this.rootLabelNodes.contains(labelNode)) {
            this.rootLabelNodes.remove(labelNode);
        }
        return result;
    }

    private int processNodeIndex(LabelNode node, IndexingAction action) {
        int processedNodes = 0;
        if (node.hasChildren()) {
            Set<LabelNode> childNodes = node.getChildren();
            for (LabelNode child : childNodes) {
                processedNodes += this.processNodeIndex(child, action);
            }
        }
        if (action == IndexingAction.Add) {
            if (this.allLabelNodes.containsKey(node.getName())) {
                throw new IllegalArgumentException(String.format("The node '%s' is already in the nodes index.", node.getName()));
            }
            this.allLabelNodes.put(node.getName(), node);
            ++processedNodes;
        } else if (action == IndexingAction.Remove) {
            if (this.allLabelNodes.containsKey(node.getName())) {
                this.allLabelNodes.remove(node.getName());
                ++processedNodes;
            }
        } else {
            throw new MulanRuntimeException(String.format("Indexing action '%s' is not supported.", new Object[]{action}));
        }
        return processedNodes;
    }

    void doReInit() {
        this.allLabelNodes.clear();
        for (LabelNode node : this.rootLabelNodes) {
            this.processNodeIndex(node, IndexingAction.Add);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rootLabelNodes = (Set)in.readObject();
        this.doReInit();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rootLabelNodes);
    }

    private static enum IndexingAction {
        Add,
        Remove;

    }
}

