/*
 * Decompiled with CFR 0.152.
 */
package mulan.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import mulan.data.LabelPairsDependenceIdentifier;
import mulan.data.LabelsPair;
import mulan.data.MultiLabelInstances;
import mulan.data.Statistics;

public class UnconditionalChiSquareIdentifier
implements LabelPairsDependenceIdentifier,
Serializable {
    private double criticalValue = 6.635;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LabelsPair[] calculateDependence(MultiLabelInstances mlInstances) {
        LabelsPair[] pairs;
        ArrayList<LabelsPair> chiPairsList = new ArrayList<LabelsPair>();
        Statistics st = new Statistics();
        int N = mlInstances.getDataSet().numInstances();
        try {
            double[][] matrix = st.calculatePhi(mlInstances);
            for (int i = 0; i < matrix.length - 1; ++i) {
                for (int j = i + 1; j < matrix[i].length; ++j) {
                    int[] pair = new int[]{i, j};
                    double val = matrix[i][j];
                    double v = Double.isNaN(val) ? 1.0E-4 : Math.pow(val, 2.0) * (double)N;
                    chiPairsList.add(new LabelsPair(pair, v));
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(UnconditionalChiSquareIdentifier.class.getSimpleName()).log(Level.SEVERE, null, e);
        }
        finally {
            pairs = new LabelsPair[chiPairsList.size()];
            chiPairsList.toArray(pairs);
            Arrays.sort(pairs, Collections.reverseOrder());
        }
        return pairs;
    }

    public void setCriticalValue(double criticalValue) {
        this.criticalValue = criticalValue;
    }

    @Override
    public double getCriticalValue() {
        return this.criticalValue;
    }
}

