/*
 * Decompiled with CFR 0.152.
 */
package mulan.evaluation.measure;

import mulan.evaluation.measure.BipartitionMeasureBase;

public abstract class LabelBasedBipartitionMeasureBase
extends BipartitionMeasureBase {
    protected int numOfLabels;
    protected double[] falseNegatives;
    protected double[] truePositives;
    protected double[] falsePositives;
    protected double[] trueNegatives;

    public LabelBasedBipartitionMeasureBase(int aNumOfLabels) {
        this.numOfLabels = aNumOfLabels;
        this.falseNegatives = new double[this.numOfLabels];
        this.truePositives = new double[this.numOfLabels];
        this.falsePositives = new double[this.numOfLabels];
        this.trueNegatives = new double[this.numOfLabels];
    }

    @Override
    public void updateBipartition(boolean[] bipartition, boolean[] truth) {
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            boolean actual = truth[labelIndex];
            boolean predicted = bipartition[labelIndex];
            if (actual) {
                if (predicted) {
                    int n = labelIndex;
                    this.truePositives[n] = this.truePositives[n] + 1.0;
                    continue;
                }
                int n = labelIndex;
                this.falseNegatives[n] = this.falseNegatives[n] + 1.0;
                continue;
            }
            if (predicted) {
                int n = labelIndex;
                this.falsePositives[n] = this.falsePositives[n] + 1.0;
                continue;
            }
            int n = labelIndex;
            this.trueNegatives[n] = this.trueNegatives[n] + 1.0;
        }
    }

    @Override
    public void reset() {
        for (int labelIndex = 0; labelIndex < this.numOfLabels; ++labelIndex) {
            this.falseNegatives[labelIndex] = 0.0;
            this.truePositives[labelIndex] = 0.0;
            this.falsePositives[labelIndex] = 0.0;
            this.trueNegatives[labelIndex] = 0.0;
        }
    }
}

