/*
 * Decompiled with CFR 0.152.
 */
package mulan.examples;

import mulan.classifier.transformation.BinaryRelevance;
import mulan.data.MultiLabelInstances;
import mulan.evaluation.Evaluation;
import mulan.evaluation.Evaluator;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.core.Instances;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.instance.RemovePercentage;

public class TrainTestExperiment {
    public static void main(String[] args) {
        try {
            String path = Utils.getOption((String)"path", (String[])args);
            String filestem = Utils.getOption((String)"filestem", (String[])args);
            String percentage = Utils.getOption((String)"percentage", (String[])args);
            System.out.println("Loading the dataset");
            MultiLabelInstances mlDataSet = new MultiLabelInstances(path + filestem + ".arff", path + filestem + ".xml");
            Instances dataSet = mlDataSet.getDataSet();
            RemovePercentage rmvp = new RemovePercentage();
            rmvp.setInvertSelection(true);
            rmvp.setPercentage(Double.parseDouble(percentage));
            rmvp.setInputFormat(dataSet);
            Instances trainDataSet = Filter.useFilter((Instances)dataSet, (Filter)rmvp);
            rmvp = new RemovePercentage();
            rmvp.setPercentage(Double.parseDouble(percentage));
            rmvp.setInputFormat(dataSet);
            Instances testDataSet = Filter.useFilter((Instances)dataSet, (Filter)rmvp);
            MultiLabelInstances train = new MultiLabelInstances(trainDataSet, path + filestem + ".xml");
            MultiLabelInstances test = new MultiLabelInstances(testDataSet, path + filestem + ".xml");
            Evaluator eval = new Evaluator();
            NaiveBayes brClassifier = new NaiveBayes();
            BinaryRelevance br = new BinaryRelevance((Classifier)brClassifier);
            br.setDebug(true);
            br.build(train);
            Evaluation results = eval.evaluate(br, test);
            System.out.println(results);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

