/*
 * Decompiled with CFR 0.152.
 */
package mulan.transformations.multiclass;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import mulan.data.MultiLabelInstances;
import mulan.transformations.RemoveAllLabels;
import mulan.transformations.multiclass.MultiClassTransformation;
import weka.core.Attribute;
import weka.core.Instance;
import weka.core.Instances;

public abstract class MultiClassTransformationBase
implements Serializable,
MultiClassTransformation {
    protected int numOfLabels;
    protected int[] labelIndices;

    @Override
    public Instances transformInstances(MultiLabelInstances mlData) throws Exception {
        this.labelIndices = mlData.getLabelIndices();
        this.numOfLabels = mlData.getNumLabels();
        Instances data = mlData.getDataSet();
        Instances transformed = new Instances(mlData.getDataSet(), 0);
        transformed = RemoveAllLabels.transformInstances(transformed, this.labelIndices);
        ArrayList<String> classValues = new ArrayList<String>(this.numOfLabels);
        for (int x = 0; x < this.numOfLabels; ++x) {
            classValues.add("Class" + (x + 1));
        }
        Attribute newClass = new Attribute("Class", classValues);
        transformed.insertAttributeAt(newClass, transformed.numAttributes());
        transformed.setClassIndex(transformed.numAttributes() - 1);
        for (int instanceIndex = 0; instanceIndex < data.numInstances(); ++instanceIndex) {
            List<Instance> result = this.transformInstance(data.instance(instanceIndex));
            for (Instance instance : result) {
                transformed.add(instance);
            }
        }
        return transformed;
    }

    abstract List<Instance> transformInstance(Instance var1);
}

