/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.awt.Color;
import org.jcamp.math.Grid1D;
import org.jcamp.math.Range1D;

public abstract class ColorMap {
    private Grid1D colorGrid;

    ColorMap() {
    }

    public ColorMap(Grid1D colorGrid) {
        this.setColorGrid(colorGrid);
    }

    public static double alignGridStep(double s) {
        double fac = 1.0;
        if (s < 1.0E-10) {
            return 1.0E-10;
        }
        while (s > 100.0) {
            s *= 0.1;
            fac *= 10.0;
        }
        while (s < 10.0) {
            s *= 10.0;
            fac *= 0.1;
        }
        if (s > 50.0) {
            s = Math.abs(s - 100.0) > Math.abs(s - 50.0) ? 50.0 : 100.0;
        } else if (s > 20.0) {
            s = Math.abs(s - 25.0) > Math.abs(s - 20.0) ? 25.0 : 20.0;
        } else if (s > 10.0) {
            s = Math.abs(s - 20.0) > Math.abs(s - 10.0) ? 20.0 : 10.0;
        }
        return s * fac;
    }

    public Grid1D getColorGrid() {
        return this.colorGrid;
    }

    public abstract Range1D.Double[] getLegend();

    public Range1D.Double getMapRange() {
        return this.colorGrid.getRange1D();
    }

    public Color[] map(double[] values) {
        Color[] colorTable = new Color[values.length];
        for (int i = 0; i < values.length; ++i) {
            colorTable[i] = this.map(values[i]);
        }
        return colorTable;
    }

    public abstract Color map(double var1);

    public void setColorGrid(Grid1D newColorGrid) {
        this.colorGrid = newColorGrid;
    }
}

