/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.awt.Color;
import org.jcamp.math.ColorMap;
import org.jcamp.math.Grid1D;
import org.jcamp.math.IInterval1D;
import org.jcamp.math.LinearGrid1D;
import org.jcamp.math.Range1D;

public class GreyColorMap
extends ColorMap {
    public GreyColorMap(Grid1D grid) {
        super(grid);
    }

    public GreyColorMap(IInterval1D data) {
        this(GreyColorMap.makeGrid(data.getRange1D()));
    }

    public GreyColorMap(Range1D range) {
        this(GreyColorMap.makeGrid(new Range1D.Double(range)));
    }

    public Range1D.Double[] getLegend() {
        int n = this.getColorGrid().getLength();
        Range1D.Double[] legend = new Range1D.Double[n];
        for (int i = 0; i < n; ++i) {
            legend[i] = new Range1D.Double(this.getColorGrid().pointAt(i), this.getColorGrid().pointAt(i + 1));
        }
        return legend;
    }

    private static LinearGrid1D makeGrid(Range1D.Double range) {
        double step = GreyColorMap.alignGridStep(range.getXWidth() / 64.0);
        double left = Math.floor(range.getXMin() / step) * step;
        double right = Math.ceil(range.getXMax() / step) * step;
        return new LinearGrid1D(left, right, step);
    }

    public Color map(double value) {
        double grid = this.getColorGrid().coordinateAt(value);
        value = 255.0 - 255.0 * (grid / (double)this.getColorGrid().getLength());
        int rgb = (int)Math.max(0.0, Math.min(255.0, value));
        return new Color(rgb, rgb, rgb);
    }
}

