/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.IArray1D;
import org.jcamp.math.IInterval1D;
import org.jcamp.math.IOrderedArray1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public class Integral
implements IInterval1D {
    private double istart;
    private double iend;
    private IOrderedArray1D xData;
    private IArray1D yData;
    private double threshold;
    protected double area;
    private int length;
    private int start;
    private int end;
    protected boolean integrationDone = false;
    protected double[] integral;

    public Integral(IOrderedArray1D xData, IArray1D yData, double start, double end) {
        this(xData, yData, start, end, 1.0);
    }

    public Integral(IOrderedArray1D xData, IArray1D yData, double start, double end, double threshold) {
        this.xData = xData;
        this.yData = yData;
        this.istart = start;
        this.iend = end;
        this.integral = new double[0];
        this.length = 0;
        this.area = 0.0;
        this.threshold = threshold;
    }

    public Integral(IOrderedArray1D xData, IArray1D yData, Range1D.Double range) {
        this(xData, yData, range.getXMin(), range.getXMax(), 1.0);
    }

    public Integral(IOrderedArray1D xData, IArray1D yData, Range1D.Double range, double threshold) {
        this(xData, yData, range.getXMin(), range.getXMax(), threshold);
    }

    public double getArea() {
        if (!this.integrationDone) {
            this.integrate();
        }
        return Math.abs(this.area);
    }

    public int getEndIndex() {
        return this.end;
    }

    public double[] getIntegral() {
        if (!this.integrationDone) {
            this.integrate();
        }
        return this.integral;
    }

    public int getLength() {
        return this.length;
    }

    public Range.Double getRange() {
        return new Range1D.Double(this.istart, this.iend);
    }

    public Range1D.Double getRange1D() {
        return new Range1D.Double(this.istart, this.iend);
    }

    public int getStartIndex() {
        return this.start;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void integrate() {
        int i;
        if (this.threshold <= 0.0) {
            this.threshold = 1.0;
        }
        boolean negative = false;
        this.start = (int)Math.floor((double)this.xData.indexAt(this.istart) + 0.5);
        this.end = (int)Math.floor((double)this.xData.indexAt(this.iend) + 0.5);
        this.istart = this.xData.pointAt(this.start);
        this.iend = this.xData.pointAt(this.end);
        if (this.start > this.end) {
            int tmp = this.start;
            this.start = this.end;
            this.end = tmp;
            negative = true;
        } else if (this.start == this.end) {
            this.area = 0.0;
            this.integral = new double[0];
        }
        this.start = Math.max(this.start, 0);
        this.end = Math.min(this.end, this.xData.getLength() - 1);
        this.length = this.end - this.start + 1;
        this.integral = new double[this.length];
        double t = this.yData.getRange1D().getXWidth() * this.threshold / 100.0;
        double x0 = this.xData.pointAt(this.start);
        double y0 = this.yData.pointAt(this.start);
        if (y0 < t) {
            y0 = 0.0;
        }
        this.integral[0] = 0.0;
        for (i = 1; i < this.length; ++i) {
            double x1 = this.xData.pointAt(this.start + i);
            double y1 = this.yData.pointAt(this.start + i);
            double dx = x1 - x0;
            if (y1 < t) {
                y1 = 0.0;
            }
            this.integral[i] = this.integral[i - 1] + 0.5 * dx * (y1 + y0);
            x0 = x1;
            y0 = y1;
        }
        this.area = this.integral[this.length - 1];
        i = 0;
        while (i < this.length) {
            int n = i++;
            this.integral[n] = this.integral[n] / this.area;
        }
        if (negative) {
            this.area = -this.area;
        }
        this.integrationDone = true;
    }

    public void setThreshold(double newThreshold) {
        this.threshold = newThreshold;
    }
}

