/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import java.io.Serializable;
import java.util.Arrays;
import org.jcamp.math.IArray1D;
import org.jcamp.math.IOrderedArray1D;
import org.jcamp.math.OrderedArray;
import org.jcamp.math.Range;
import org.jcamp.math.Range1D;

public class OrderedArray1D
extends OrderedArray
implements IOrderedArray1D,
Cloneable,
Serializable {
    private double[] array;
    private Range1D.Double range;

    public OrderedArray1D(double[] values) {
        this(values, true);
    }

    public OrderedArray1D(double[] values, boolean copy) {
        this(values, copy, false);
    }

    public OrderedArray1D(double[] values, boolean copy, boolean sort) {
        super(values.length);
        this.array = copy ? (double[])values.clone() : values;
        if (sort) {
            Arrays.sort(this.array);
        }
        this.calcRange();
    }

    public OrderedArray1D(IOrderedArray1D from) {
        super(from.getLength());
        int n = from.getLength();
        this.array = new double[n];
        for (int i = 0; i < n; ++i) {
            this.array[i] = from.pointAt(i);
        }
        this.range = from.getRange1D();
    }

    private void calcRange() {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        int length = this.getLength();
        for (int i = 0; i < length; ++i) {
            if (this.array[i] < min) {
                min = this.array[i];
            }
            if (!(this.array[i] > max)) continue;
            max = this.array[i];
        }
        this.range = new Range1D.Double(min, max);
    }

    public Object clone() {
        OrderedArray1D array = null;
        array = (OrderedArray1D)super.clone();
        array.array = (double[])this.array.clone();
        array.range = (Range1D.Double)this.range.clone();
        return array;
    }

    public double[] elementAt(int index) {
        return new double[]{this.array[index]};
    }

    public double[][] elementsAt(int[] index) {
        double[][] values = new double[1][index.length];
        for (int i = 0; i < index.length; ++i) {
            int index_i = index[i];
            values[0][i] = this.array[index_i];
        }
        return values;
    }

    public IArray1D getArray(int index) throws ArrayIndexOutOfBoundsException {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this;
    }

    public final int getDimension() {
        return 1;
    }

    public Range.Double getRange() {
        return (Range1D.Double)this.range.clone();
    }

    public Range1D.Double getRange1D() {
        return (Range1D.Double)this.range.clone();
    }

    public int indexAt(double p) {
        int il = 0;
        int ir = this.array.length - 1;
        int index = (il + ir) / 2;
        double pl = this.pointAt(il);
        double pr = this.pointAt(ir);
        if (p < pl) {
            return il;
        }
        if (p > pr) {
            return ir;
        }
        while (ir - il > 1) {
            double pi = this.pointAt(index);
            if (p > pi) {
                il = index;
                pl = pi;
            } else {
                if (Math.abs(p - pi) < 9.9E-324) {
                    return index;
                }
                ir = index;
                pr = pi;
            }
            index = (il + ir) / 2;
        }
        if (p < 0.5 * (pl + pr)) {
            return il;
        }
        return ir;
    }

    public double pointAt(int index) {
        return this.array[index];
    }

    public void scale(double amount) {
        int i = 0;
        while (i < this.array.length) {
            int n = i++;
            this.array[n] = this.array[n] * amount;
        }
        this.range = new Range1D.Double(this.range.getXMin() * amount, this.range.getXMax() * amount);
    }

    public double[] toArray() {
        double[] a = new double[this.array.length];
        System.arraycopy(this.array, 0, a, 0, this.array.length);
        return a;
    }

    public void translate(double amount) {
        int i = 0;
        while (i < this.array.length) {
            int n = i++;
            this.array[n] = this.array[n] + amount;
        }
        this.range.translate(amount);
    }
}

