/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.Grid1D;
import org.jcamp.math.Grid2D;
import org.jcamp.math.IArray1D;
import org.jcamp.math.NullGrid1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range2D;

public class RectangularGrid2D
extends Grid2D {
    private Grid1D x;
    private Grid1D y;

    public RectangularGrid2D() {
        this.x = new NullGrid1D();
        this.y = new NullGrid1D();
    }

    public RectangularGrid2D(Grid1D x, Grid1D y) {
        super(x.getLength(), y.getLength());
        this.x = (Grid1D)x.clone();
        this.y = (Grid1D)y.clone();
    }

    public Object clone() {
        RectangularGrid2D grid = null;
        grid = (RectangularGrid2D)super.clone();
        grid.x = (Grid1D)this.x.clone();
        grid.y = (Grid1D)this.y.clone();
        return grid;
    }

    public double[] coordinateAt(double x, double y) {
        double gridX = this.x.coordinateAt(x);
        double gridY = this.y.coordinateAt(y);
        double[] grid = new double[]{gridX, gridY};
        return grid;
    }

    public double[][] coordinatesAt(double[] xarr, double[] yarr) {
        double[] gridX = this.x.coordinatesAt(xarr);
        double[] gridY = this.y.coordinatesAt(yarr);
        double[][] grid = new double[][]{gridX, gridY};
        return grid;
    }

    public IArray1D getArray(int index) throws ArrayIndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Range.Double getRange() {
        return new Range2D.Double(this.x.getRange1D(), this.y.getRange1D());
    }

    public Range2D.Double getRange2D() {
        return new Range2D.Double(this.x.getRange1D(), this.y.getRange1D());
    }

    public IArray1D getXArray() {
        return this.x;
    }

    public Grid1D getXGrid() {
        return this.x;
    }

    public IArray1D getYArray() {
        return this.y;
    }

    public Grid1D getYGrid() {
        return this.y;
    }

    public double[] gridPointAt(int index) {
        int indexX = index % this.getXLength();
        int indexY = index / this.getXLength();
        double valueX = this.x.pointAt(indexX);
        double valueY = this.y.pointAt(indexY);
        double[] values = new double[]{valueX, valueY};
        return values;
    }

    public double[][] gridPointsAt(int[] index) {
        int n = index.length;
        int lengthX = this.getXLength();
        int lengthY = this.getYLength();
        int length = this.getLength();
        int[] indexX = new int[n];
        int[] indexY = new int[n];
        for (int i = 0; i < n; ++i) {
            if (0 <= index[i] && index[i] < length) {
                indexX[i] = index[i] % lengthX;
                indexY[i] = index[i] / lengthX;
                continue;
            }
            indexX[i] = -1;
            indexY[i] = -1;
        }
        double[] valuesX = this.x.pointsAt(indexX);
        double[] valuesY = this.y.pointsAt(indexY);
        double[][] values = new double[2][n];
        values[0] = valuesX;
        values[1] = valuesY;
        return values;
    }

    public void setXGrid(Grid1D newX) {
        this.x = newX;
        this.setXLength(newX.getLength());
        this.setLength(this.getXLength() * this.getYLength());
    }

    public void setYGrid(Grid1D newY) {
        this.y = newY;
        this.setYLength(newY.getLength());
        this.setLength(this.getXLength() * this.getYLength());
    }

    public double[] valueAt(double gridx, double gridy) {
        double valueX = this.x.valueAt(gridx);
        double valueY = this.y.valueAt(gridy);
        double[] value = new double[]{valueX, valueY};
        return value;
    }

    public double[][] valuesAt(double[] gridx, double[] gridy) {
        double[] valueX = this.x.valuesAt(gridx);
        double[] valueY = this.y.valuesAt(gridy);
        double[][] value = new double[][]{valueX, valueY};
        return value;
    }
}

