/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.AxisMap;
import org.jcamp.math.Grid1D;
import org.jcamp.math.IInterval1D;
import org.jcamp.math.LinearGrid1D;
import org.jcamp.math.Range1D;

public class ReversedLinearAxisMap
extends AxisMap {
    public ReversedLinearAxisMap(IInterval1D data) {
        super(data);
    }

    public ReversedLinearAxisMap(IInterval1D data, Range1D fullViewRange) {
        super(data);
        this.setFullViewRange(fullViewRange);
        this.calcGrid();
    }

    protected void calcGrid() {
        if (this.realZoomRange.getXWidth() > 0.0) {
            double gridStep = ReversedLinearAxisMap.alignTickStep(this.realZoomRange.getXWidth() / 5.0);
            double gridStart = Math.ceil(this.realZoomRange.getXMax() / gridStep) * gridStep;
            double gridEnd = Math.floor(this.realZoomRange.getXMin() / gridStep) * gridStep;
            this.grid = new LinearGrid1D(gridStart, gridEnd, -gridStep);
            this.gridZoomRange.set(this.grid.coordinateAt(this.realZoomRange.getXMax()), this.grid.coordinateAt(this.realZoomRange.getXMin()));
        }
    }

    public Grid1D map(Grid1D grid) {
        if (grid instanceof LinearGrid1D) {
            return new LinearGrid1D(this.map(((LinearGrid1D)grid).getStart()), this.map(((LinearGrid1D)grid).getEnd()), grid.getLength());
        }
        return super.map(grid);
    }
}

