/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.math;

import org.jcamp.math.Array1D;
import org.jcamp.math.Grid2D;
import org.jcamp.math.IArray1D;
import org.jcamp.math.Range;
import org.jcamp.math.Range2D;

public class TopologicalGrid2D
extends Grid2D {
    private double[][] samples;
    private Range2D.Double range = new Range2D.Double();

    public TopologicalGrid2D() {
        this.samples = new double[0][];
    }

    public TopologicalGrid2D(double[][] samples, int lengthX, int lengthY) {
        this(samples, lengthX, lengthY, true);
    }

    public TopologicalGrid2D(double[][] samples, int lengthX, int lengthY, boolean copy) {
        super(lengthX, lengthY);
        this.setSamples(samples, lengthX, lengthY, copy);
    }

    private static double area(double ax, double ay, double bx, double by, double cx, double cy) {
        return 0.5 * ((ay + cy) * (cx - ax) + (cy + by) * (bx - cx) - (ay + by) * (bx - ax));
    }

    public Object clone() {
        TopologicalGrid2D grid = null;
        grid = (TopologicalGrid2D)super.clone();
        grid.range = (Range2D.Double)this.range.clone();
        grid.setSamples(this.samples, this.getXLength(), this.getYLength(), true);
        return grid;
    }

    public double[] coordinateAt(double valuex, double valuey) {
        double[] grid = new double[2];
        int lengthX = this.getXLength();
        int lengthY = this.getYLength();
        double a = TopologicalGrid2D.area(this.samples[0][(lengthY - 1) * lengthX], this.samples[1][(lengthY - 1) * lengthX], this.samples[0][0], this.samples[1][0], this.samples[0][lengthX - 1], this.samples[1][lengthX - 1]);
        boolean positive = a > 0.0;
        grid[0] = Double.NaN;
        grid[1] = Double.NaN;
        int dx = (lengthX - 1) / 2;
        int dy = (lengthX - 1) / 2;
        int ix0 = dx;
        int iy0 = dy;
        double xp = valuex;
        double yp = valuey;
        for (int iter = 0; iter < lengthX * lengthY; ++iter) {
            if (ix0 < 0) {
                ix0 = 0;
            }
            if (ix0 > lengthX - 2) {
                ix0 = lengthX - 2;
            }
            if (iy0 < 0) {
                iy0 = 0;
            }
            if (iy0 > lengthY - 2) {
                iy0 = lengthY - 2;
            }
            int ix1 = ix0 + 1;
            int iy1 = iy0 + 1;
            double xa = this.samples[0][iy0 * lengthX + ix0];
            double ya = this.samples[1][iy0 * lengthX + ix0];
            double xb = this.samples[0][iy0 * lengthX + ix1];
            double yb = this.samples[1][iy0 * lengthX + ix1];
            double xc = this.samples[0][iy1 * lengthX + ix1];
            double yc = this.samples[1][iy1 * lengthX + ix1];
            double xd = this.samples[0][iy1 * lengthX + ix0];
            double yd = this.samples[1][iy1 * lengthX + ix0];
            double pa = TopologicalGrid2D.area(xp, yp, xb, yb, xd, yd);
            double pb = TopologicalGrid2D.area(xa, ya, xp, yp, xd, yd);
            double pd = TopologicalGrid2D.area(xa, ya, xb, yb, xp, yp);
            if (positive && pa < 0.0 || !positive && pa > 0.0) {
                pb = TopologicalGrid2D.area(xp, yp, xc, yc, xd, yd);
                double pc = TopologicalGrid2D.area(xb, yb, xp, yp, xd, yd);
                pd = TopologicalGrid2D.area(xb, yb, xc, yc, xp, yp);
                if (positive && pc < 0.0 || !positive && pc > 0.0) break;
                if (positive && pd < 0.0 || !positive && pd > 0.0) {
                    ix0 += dx;
                    dx /= 2;
                    continue;
                }
                if (positive && pb < 0.0 || !positive && pb > 0.0) {
                    iy0 += dy;
                    dy /= 2;
                    continue;
                }
                double gdx = ((xc - xp) * (yb - yc) + (yp - yc) * (xb - xc)) / ((xd - xc) * (yb - yc) - (yd - yc) * (xb - xc));
                double gdy = ((yd - yc) * (xc - xp) + (xd - xc) * (yp - yc)) / ((xb - xc) * (yd - yc) - (xd - xc) * (yb - yc));
                grid[0] = (double)ix1 + gdx;
                grid[1] = (double)iy1 + gdy;
                break;
            }
            if (positive && pb < 0.0 || !positive && pb > 0.0) {
                ix0 -= dx;
                dx /= 2;
                continue;
            }
            if (positive && pd < 0.0 || !positive && pb > 0.0) {
                iy0 -= dy;
                dy /= 2;
                continue;
            }
            double gdx = ((yd - ya) * (xp - xa) + (ya - yp) * (xd - xa)) / ((yd - ya) * (xb - xa) + (ya - yb) * (xd - xa));
            double gdy = ((xp - xa) * (yb - ya) + (ya - yp) * (xb - xa)) / ((xd - xa) * (yb - ya) + (ya - yd) * (xb - xa));
            grid[0] = (double)ix0 + gdx;
            grid[1] = (double)iy0 + gdy;
            break;
        }
        return grid;
    }

    public double[][] coordinatesAt(double[] valuex, double[] valuey) {
        int n = Math.min(valuex.length, valuey.length);
        int lengthX = this.getXLength();
        int lengthY = this.getYLength();
        double[][] grid = new double[2][n];
        double a = TopologicalGrid2D.area(this.samples[0][(lengthY - 1) * lengthX], this.samples[1][(lengthY - 1) * lengthX], this.samples[0][0], this.samples[1][0], this.samples[0][lengthX - 1], this.samples[1][lengthX - 1]);
        boolean positive = a > 0.0;
        block0: for (int i = 0; i < n; ++i) {
            grid[0][i] = Double.NaN;
            grid[1][i] = Double.NaN;
            int dx = (lengthX - 1) / 2;
            int dy = (lengthX - 1) / 2;
            int ix0 = dx;
            int iy0 = dy;
            double xp = valuex[i];
            double yp = valuey[i];
            for (int iter = 0; iter < lengthX * lengthY; ++iter) {
                double gdy;
                double gdx;
                if (ix0 < 0) {
                    ix0 = 0;
                }
                if (ix0 > lengthX - 2) {
                    ix0 = lengthX - 2;
                }
                if (iy0 < 0) {
                    iy0 = 0;
                }
                if (iy0 > lengthY - 2) {
                    iy0 = lengthY - 2;
                }
                int ix1 = ix0 + 1;
                int iy1 = iy0 + 1;
                double xa = this.samples[0][iy0 * lengthX + ix0];
                double ya = this.samples[1][iy0 * lengthX + ix0];
                double xb = this.samples[0][iy0 * lengthX + ix1];
                double yb = this.samples[1][iy0 * lengthX + ix1];
                double xc = this.samples[0][iy1 * lengthX + ix1];
                double yc = this.samples[1][iy1 * lengthX + ix1];
                double xd = this.samples[0][iy1 * lengthX + ix0];
                double yd = this.samples[1][iy1 * lengthX + ix0];
                double pa = TopologicalGrid2D.area(xp, yp, xb, yb, xd, yd);
                double pb = TopologicalGrid2D.area(xa, ya, xp, yp, xd, yd);
                double pd = TopologicalGrid2D.area(xa, ya, xb, yb, xp, yp);
                if (positive && pa < 0.0 || !positive && pa > 0.0) {
                    pb = TopologicalGrid2D.area(xp, yp, xc, yc, xd, yd);
                    double pc = TopologicalGrid2D.area(xb, yb, xp, yp, xd, yd);
                    pd = TopologicalGrid2D.area(xb, yb, xc, yc, xp, yp);
                    if (positive && pc < 0.0 || !positive && pc > 0.0) continue block0;
                    if (positive && pd < 0.0 || !positive && pd > 0.0) {
                        ix0 += dx;
                        dx /= 2;
                        continue;
                    }
                    if (positive && pb < 0.0 || !positive && pb > 0.0) {
                        iy0 += dy;
                        dy /= 2;
                        continue;
                    }
                    gdx = ((xc - xp) * (yb - yc) + (yp - yc) * (xb - xc)) / ((xd - xc) * (yb - yc) - (yd - yc) * (xb - xc));
                    gdy = ((yd - yc) * (xc - xp) + (xd - xc) * (yp - yc)) / ((xb - xc) * (yd - yc) - (xd - xc) * (yb - yc));
                    grid[0][i] = (double)ix1 + gdx;
                    grid[1][i] = (double)iy1 + gdy;
                    continue block0;
                }
                if (positive && pb < 0.0 || !positive && pb > 0.0) {
                    ix0 -= dx;
                    dx /= 2;
                    continue;
                }
                if (positive && pd < 0.0 || !positive && pb > 0.0) {
                    iy0 -= dy;
                    dy /= 2;
                    continue;
                }
                gdx = ((yd - ya) * (xp - xa) + (ya - yp) * (xd - xa)) / ((yd - ya) * (xb - xa) + (ya - yb) * (xd - xa));
                gdy = ((xp - xa) * (yb - ya) + (ya - yp) * (xb - xa)) / ((xd - xa) * (yb - ya) + (ya - yd) * (xb - xa));
                grid[0][i] = (double)ix0 + gdx;
                grid[1][i] = (double)iy0 + gdy;
                continue block0;
            }
        }
        return grid;
    }

    public IArray1D getArray(int index) throws ArrayIndexOutOfBoundsException {
        switch (index) {
            case 0: {
                return new Array1D(this.samples[0], false);
            }
            case 1: {
                return new Array1D(this.samples[1], false);
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public Range.Double getRange() {
        return this.range;
    }

    public Range2D.Double getRange2D() {
        return this.range;
    }

    public double[][] getSamples() {
        return this.samples;
    }

    public IArray1D getXArray() {
        return new Array1D(this.samples[0]);
    }

    public IArray1D getYArray() {
        return new Array1D(this.samples[1]);
    }

    public double[] gridPointAt(int index) {
        double[] values = new double[2];
        if (index >= 0 && index <= this.getLength()) {
            values[0] = this.samples[0][index];
            values[1] = this.samples[1][index];
        } else {
            values[0] = Double.NaN;
            values[1] = Double.NaN;
        }
        return values;
    }

    public double[][] gridPointsAt(int[] index) {
        int length = this.getLength();
        double[][] values = new double[2][length];
        int n = index.length;
        for (int i = 0; i < n; ++i) {
            int index_i = index[i];
            if (index_i >= 0 && index_i <= length) {
                values[0][i] = this.samples[0][index_i];
                values[1][i] = this.samples[1][index_i];
                continue;
            }
            values[0][i] = Double.NaN;
            values[1][i] = Double.NaN;
        }
        return values;
    }

    public void setSamples(double[][] newSamples, int lengthX, int lengthY) {
        this.setSamples(newSamples, lengthX, lengthY, true);
    }

    public void setSamples(double[][] newSamples, int lengthX, int lengthY, boolean copy) {
        int length = lengthX * lengthY;
        this.setLength(length);
        this.setXLength(lengthX);
        this.setYLength(lengthY);
        if (newSamples.length != length) {
            throw new IllegalArgumentException("bad sample array length");
        }
        if (copy) {
            this.samples = new double[2][];
            this.samples[0] = (double[])newSamples[0].clone();
            this.samples[1] = (double[])newSamples[1].clone();
        } else {
            this.samples = newSamples;
        }
        this.range.set(this.samples[0][0], this.samples[0][0], this.samples[1][0], this.samples[1][0]);
        for (int i = 1; i < length; ++i) {
            double xmax = this.range.getXMax();
            double xmin = this.range.getXMin();
            double ymax = this.range.getYMax();
            double ymin = this.range.getYMin();
            if (this.samples[0][i] > xmax) {
                xmax = this.samples[0][i];
            }
            if (this.samples[1][i] > ymax) {
                ymax = this.samples[1][i];
            }
            if (this.samples[0][i] < xmin) {
                xmin = this.samples[0][i];
            }
            if (this.samples[1][i] < ymin) {
                ymin = this.samples[1][i];
            }
            this.range.set(xmin, xmax, ymin, ymax);
        }
    }

    public double[] valueAt(double gridx, double gridy) {
        int gy0;
        double[] value = new double[2];
        double gx = gridx;
        double gy = gridy;
        int lengthX = this.getXLength();
        int lengthY = this.getYLength();
        if (gx < -0.5 || gx > (double)lengthX - 0.5 || gy < -0.5 || gy > (double)lengthY - 0.5) {
            value[1] = Double.NaN;
            value[0] = Double.NaN;
            return value;
        }
        int gx0 = (int)Math.floor(gx + 0.5);
        if (gx0 < 0) {
            gx0 = 0;
        }
        if (gx0 > lengthX - 2) {
            gx0 = lengthX - 2;
        }
        if ((gy0 = (int)Math.floor(gy + 0.5)) < 0) {
            gy0 = 0;
        }
        if (gy0 > lengthY - 2) {
            gy0 = lengthY - 2;
        }
        int lb = gy0 * lengthX + gx0;
        int rb = gy0 * lengthX + gx0 + 1;
        int lt = (gy0 + 1) * lengthX + gx0;
        int rt = (gy0 + 1) * lengthX + gx0 + 1;
        double dx = gx - (double)gx0;
        double dy = gy - (double)gy0;
        if (dx + dy - 1.0 < 0.0) {
            value[0] = this.samples[0][lb] + dx * (this.samples[0][rb] - this.samples[0][lb]) + dy * (this.samples[0][lt] - this.samples[0][lb]);
            value[1] = this.samples[1][lb] + dx * (this.samples[1][rb] - this.samples[1][lb]) + dy * (this.samples[1][lt] - this.samples[1][lb]);
        } else {
            dx = (double)(gx0 + 1) - gx;
            dy = (double)(gy0 + 1) - gy;
            value[0] = this.samples[0][rt] + dx * (this.samples[0][lt] - this.samples[0][rt]) + dy * (this.samples[0][rb] - this.samples[0][rt]);
            value[1] = this.samples[1][rt] + dx * (this.samples[1][lt] - this.samples[1][rt]) + dy * (this.samples[1][rb] - this.samples[1][rt]);
        }
        return value;
    }

    public double[][] valuesAt(double[] gridx, double[] gridy) {
        int n = Math.min(gridx.length, gridy.length);
        int lengthX = this.getXLength();
        int lengthY = this.getYLength();
        double[][] value = new double[2][n];
        for (int i = 0; i < n; ++i) {
            int gy0;
            double gx = gridx[i];
            double gy = gridy[i];
            if (gx < -0.5 || gx > (double)lengthX - 0.5 || gy < -0.5 || gy > (double)lengthY - 0.5) {
                value[1][i] = Double.NaN;
                value[0][i] = Double.NaN;
                continue;
            }
            int gx0 = (int)Math.floor(gx + 0.5);
            if (gx0 < 0) {
                gx0 = 0;
            }
            if (gx0 > lengthX - 2) {
                gx0 = lengthX - 2;
            }
            if ((gy0 = (int)Math.floor(gy + 0.5)) < 0) {
                gy0 = 0;
            }
            if (gy0 > lengthY - 2) {
                gy0 = lengthY - 2;
            }
            int lb = gy0 * lengthX + gx0;
            int rb = gy0 * lengthX + gx0 + 1;
            int lt = (gy0 + 1) * lengthX + gx0;
            int rt = (gy0 + 1) * lengthX + gx0 + 1;
            double dx = gx - (double)gx0;
            double dy = gy - (double)gy0;
            if (dx + dy - 1.0 < 0.0) {
                value[0][i] = this.samples[0][lb] + dx * (this.samples[0][rb] - this.samples[0][lb]) + dy * (this.samples[0][lt] - this.samples[0][lb]);
                value[1][i] = this.samples[1][lb] + dx * (this.samples[1][rb] - this.samples[1][lb]) + dy * (this.samples[1][lt] - this.samples[1][lb]);
                continue;
            }
            dx = (double)(gx0 + 1) - gx;
            dy = (double)(gy0 + 1) - gy;
            value[0][i] = this.samples[0][rt] + dx * (this.samples[0][lt] - this.samples[0][rt]) + dy * (this.samples[0][rb] - this.samples[0][rt]);
            value[1][i] = this.samples[1][rt] + dx * (this.samples[1][lt] - this.samples[1][rt]) + dy * (this.samples[1][rb] - this.samples[1][rt]);
        }
        return value;
    }
}

