/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import org.jcamp.parser.DataType;
import org.jcamp.parser.JCAMPException;

public class AFFNGroup {
    private final DataType type;
    private final String[] varSymbols;
    private double[] values;

    public AFFNGroup(String[] symbols) {
        this.type = null;
        this.varSymbols = symbols;
        this.values = new double[symbols.length];
    }

    public AFFNGroup(String[] symbols, double[] values) {
        this.type = null;
        this.varSymbols = symbols;
        this.values = new double[symbols.length];
        for (int i = 0; i < symbols.length; ++i) {
            this.values[i] = values[i];
        }
    }

    public AFFNGroup(double x, double y) {
        this.type = DataType.XY;
        this.varSymbols = DataType.XY.getSymbols();
        this.values = new double[]{x, y};
    }

    public AFFNGroup(double x, double y, double w) {
        this.type = DataType.XYW;
        this.varSymbols = DataType.XYW.getSymbols();
        this.values = new double[]{x, y, w};
    }

    public final String[] getSymbols() {
        return this.varSymbols;
    }

    public final DataType getType() {
        return this.type;
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public double getValue(String c) throws JCAMPException {
        return this.values[this.indexOfSymbol(c)];
    }

    public int indexOfSymbol(String symbol) throws JCAMPException {
        for (int i = 0; i < this.varSymbols.length; ++i) {
            if (!symbol.equalsIgnoreCase(this.varSymbols[i])) continue;
            return i;
        }
        throw new JCAMPException("unknown ASDF variable: " + symbol);
    }

    public void setValue(int index, double value) {
        this.values[index] = value;
    }

    public void setValue(String symbol, double value) throws JCAMPException {
        this.values[this.indexOfSymbol((String)symbol)] = value;
    }

    public int size() {
        return this.values.length;
    }
}

