/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.jcamp.parser.AFFNGroup;
import org.jcamp.parser.DataType;
import org.jcamp.parser.DataVariableInfo;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.LineTokenizer;

public class AFFNTokenizer
implements Enumeration {
    private final DataType type;
    private String data;
    private final String[] varSymbols;
    private int pos;
    private int length;

    public AFFNTokenizer(String[] symbols, String data) throws JCAMPException {
        this.type = AFFNTokenizer.checkSymbols(symbols);
        this.varSymbols = this.type == null ? symbols : this.type.getSymbols();
        this.data = AFFNTokenizer.normalizeData(this.varSymbols.length, data);
        this.length = this.data.length();
    }

    public AFFNTokenizer(JCAMPDataRecord ldr) throws JCAMPException {
        DataVariableInfo varInfo = new DataVariableInfo(ldr);
        this.type = AFFNTokenizer.checkSymbols(varInfo.getSymbols());
        this.varSymbols = this.type == null ? varInfo.getSymbols() : this.type.getSymbols();
        String ldrData = ldr.getContent();
        LineTokenizer lt = new LineTokenizer(ldrData);
        lt.nextLine();
        this.data = AFFNTokenizer.normalizeData(this.varSymbols.length, ldrData.substring(lt.getPosition()));
        this.length = this.data.length();
    }

    private static DataType checkSymbols(String[] varSymbols) throws JCAMPException {
        if (varSymbols == null || varSymbols.length == 0) {
            throw new JCAMPException("bad variable declaration");
        }
        if (varSymbols.length == 2) {
            if (varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y")) {
                return DataType.XY;
            }
        } else if (varSymbols.length == 3 && varSymbols[0].equalsIgnoreCase("X") && varSymbols[1].equalsIgnoreCase("Y") && varSymbols[2].equalsIgnoreCase("W")) {
            return DataType.XYW;
        }
        return null;
    }

    public final String[] getSymbols() {
        return this.varSymbols;
    }

    public final DataType getType() {
        return this.type;
    }

    public boolean hasMoreElements() {
        return this.hasMoreGroups();
    }

    public boolean hasMoreGroups() {
        return this.pos < this.length - 1;
    }

    public Object nextElement() {
        try {
            return this.nextGroup();
        }
        catch (JCAMPException e) {
            throw new NoSuchElementException(e.getMessage());
        }
    }

    public AFFNGroup nextGroup() throws JCAMPException {
        if (this.pos >= this.length) {
            throw new JCAMPException("parsed beyond end of AFFN block");
        }
        if (DataType.XY.equals(this.type)) {
            return this.nextXYGroup();
        }
        if (DataType.XYW.equals(this.type)) {
            return this.nextXYWGroup();
        }
        int n = this.varSymbols.length;
        double[] values = new double[n];
        for (int i = 0; i < n - 1; ++i) {
            int p = this.data.indexOf(",", this.pos);
            if (p < 0) {
                throw new JCAMPException("missing data in AFFN block");
            }
            values[i] = Double.parseDouble(this.data.substring(this.pos, p));
            this.pos = p + 1;
        }
        int p = this.data.indexOf(";", this.pos);
        if (p < 0) {
            throw new JCAMPException("extra data in AFFN block");
        }
        values[n - 1] = Double.parseDouble(this.data.substring(this.pos, p));
        this.pos = p + 1;
        return new AFFNGroup(this.varSymbols, values);
    }

    private AFFNGroup nextXYGroup() throws JCAMPException {
        int p = this.data.indexOf(44, this.pos);
        if (p < 0) {
            throw new JCAMPException("missing x data");
        }
        double x = Double.parseDouble(this.data.substring(this.pos, p));
        this.pos = p + 1;
        p = this.data.indexOf(59, this.pos);
        if (p < 0) {
            throw new JCAMPException("missing y data");
        }
        double y = Double.parseDouble(this.data.substring(this.pos, p));
        this.pos = p + 1;
        return new AFFNGroup(x, y);
    }

    private AFFNGroup nextXYWGroup() throws JCAMPException {
        int p = this.data.indexOf(44, this.pos);
        if (p < 0) {
            throw new JCAMPException("missing x data");
        }
        double x = Double.parseDouble(this.data.substring(this.pos, p));
        this.pos = p + 1;
        p = this.data.indexOf(44, this.pos);
        if (p < 0) {
            throw new JCAMPException("missing y data");
        }
        double y = Double.parseDouble(this.data.substring(this.pos, p));
        this.pos = p + 1;
        p = this.data.indexOf(59, this.pos);
        if (p < 0) {
            throw new JCAMPException("missing w data");
        }
        double w = Double.parseDouble(this.data.substring(this.pos, p));
        this.pos = p + 1;
        return new AFFNGroup(x, y, w);
    }

    private static String normalizeData(int groupLength, String orig) throws JCAMPException {
        StringBuffer normal = new StringBuffer();
        boolean inWS = false;
        boolean inNumber = false;
        int j = 0;
        for (int i = 0; i < orig.length(); ++i) {
            char c = orig.charAt(i);
            if (Character.isWhitespace(c)) {
                if (inNumber) {
                    inNumber = false;
                    if (++j < groupLength) {
                        normal.append(',');
                    } else {
                        normal.append(';');
                        j = 0;
                    }
                }
                inWS = true;
                continue;
            }
            if (c == ';') {
                if (!inNumber) continue;
                inNumber = false;
                if (++j < groupLength) {
                    throw new JCAMPException("missing numbers in AFFN data");
                }
                if (j > groupLength) {
                    throw new JCAMPException("extra numbers in AFFN data");
                }
                normal.append(';');
                j = 0;
                continue;
            }
            if (c == ',') {
                if (!inNumber) continue;
                inNumber = false;
                if (++j >= groupLength) {
                    throw new JCAMPException("extra commas in AFFN data");
                }
                normal.append(',');
                continue;
            }
            if (Character.isDigit(c) || c == '.' || c == '+' || c == '-' || c == 'e' || c == 'E') {
                normal.append(c);
                inWS = false;
                inNumber = true;
                continue;
            }
            throw new JCAMPException("unexpected character '" + c + "' in AFFN data");
        }
        normal.append(';');
        return normal.toString();
    }
}

