/*
 * Decompiled with CFR 0.152.
 */
package org.jcamp.parser;

import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jcamp.parser.ASDFLexer;
import org.jcamp.parser.ASDFParser;
import org.jcamp.parser.DataVariableInfo;
import org.jcamp.parser.JCAMPDataRecord;
import org.jcamp.parser.JCAMPException;
import org.jcamp.parser.ReplacingCheckHandler;

public class ASDFDecoder {
    private static Log log = LogFactory.getLog((Class)(class$org$jcamp$parser$ASDFDecoder == null ? (class$org$jcamp$parser$ASDFDecoder = ASDFDecoder.class$("org.jcamp.parser.ASDFDecoder")) : class$org$jcamp$parser$ASDFDecoder));
    private static final byte[] CRLF = new byte[]{13, 10};
    private boolean isUnicodeAware = false;
    private boolean isValidating = true;
    static /* synthetic */ Class class$org$jcamp$parser$ASDFDecoder;

    public int[] decode(JCAMPDataRecord ldr, double firstX, double lastX, double xFactor, int nPoints) throws JCAMPException {
        try {
            DataVariableInfo varInfo = new DataVariableInfo(ldr);
            if (varInfo.isIncremental()) {
                ASDFLexer lexer;
                Object[] xyData;
                if (this.isUnicodeAware) {
                    xyData = ASDFDecoder.getASDFBlockAsChars(ldr.getContent());
                    lexer = new ASDFLexer(new CharArrayReader((char[])xyData));
                } else {
                    xyData = ASDFDecoder.getASDFBlockAsBytes(ldr.getContent());
                    lexer = new ASDFLexer(new ByteArrayInputStream((byte[])xyData));
                }
                ASDFParser parser = new ASDFParser(lexer);
                if (this.isValidating) {
                    parser.setCheckHandler(new ReplacingCheckHandler(firstX, lastX, xFactor, nPoints));
                }
                parser.parse(nPoints);
                return parser.getYData();
            }
            String msg = "data not in ASDF encoding";
            log.error((Object)msg);
            throw new JCAMPException(msg);
        }
        catch (Throwable e) {
            throw new JCAMPException(e.getMessage());
        }
    }

    public int[] decode(String difdup, double firstX, double lastX, double xFactor, int nPoints) throws JCAMPException {
        try {
            ASDFLexer lexer = new ASDFLexer(new StringReader(difdup));
            ASDFParser parser = new ASDFParser(lexer);
            if (this.isValidating) {
                parser.setCheckHandler(new ReplacingCheckHandler(firstX, lastX, xFactor, nPoints));
            }
            parser.parse(nPoints);
            return parser.getYData();
        }
        catch (Exception e) {
            String msg = "ASDF parsing failed";
            log.error((Object)msg);
            throw new JCAMPException(msg);
        }
    }

    public void enableValidation(boolean newIsValidating) {
        this.isValidating = newIsValidating;
    }

    private static byte[] getASDFBlockAsBytes(String s) {
        int pos;
        int length = s.length();
        for (pos = 0; pos < length; ++pos) {
            char c = s.charAt(pos);
            if (c == '\r') {
                if ((c = s.charAt(++pos)) == '\n') break;
                --pos;
                break;
            }
            if (c == '\n') break;
        }
        if (pos == length) {
            return CRLF;
        }
        byte[] buffer = new byte[length - ++pos + 2];
        int i = 0;
        while (pos < length) {
            buffer[i] = (byte)s.charAt(pos);
            ++pos;
            ++i;
        }
        buffer[i] = CRLF[0];
        buffer[++i] = CRLF[1];
        return buffer;
    }

    private static char[] getASDFBlockAsChars(String s) {
        int pos;
        int length = s.length();
        for (pos = 0; pos < length; ++pos) {
            char c = s.charAt(pos);
            if (c == '\r') {
                if ((c = s.charAt(++pos)) == '\n') break;
                --pos;
                break;
            }
            if (c == '\n') break;
        }
        if (pos == length) {
            return new char[]{'\r', '\n'};
        }
        char[] buffer = new char[length - ++pos + 2];
        int i = 0;
        while (pos < length) {
            buffer[i] = s.charAt(pos);
            ++pos;
            ++i;
        }
        buffer[i] = 13;
        buffer[++i] = 10;
        return buffer;
    }

    public boolean isUnicodeAware() {
        return this.isUnicodeAware;
    }

    public boolean isValidating() {
        return this.isValidating;
    }

    public void setUnicodeAwareness(boolean newIsUnicodeAware) {
        this.isUnicodeAware = newIsUnicodeAware;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

